/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandPriorityCalculator;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.commandhandling.gateway.FutureCommandResult;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DefaultCommandGateway
implements CommandGateway {
    private final CommandBus commandBus;
    private final MessageTypeResolver messageTypeResolver;
    private final CommandPriorityCalculator priorityCalculator;
    private final RoutingStrategy routingKeyResolver;

    public DefaultCommandGateway(@Nonnull CommandBus commandBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull CommandPriorityCalculator priorityCalculator, @Nonnull RoutingStrategy routingKeyResolver) {
        this.commandBus = Objects.requireNonNull(commandBus, "The commandBus may not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The messageTypeResolver may not be null.");
        this.priorityCalculator = Objects.requireNonNull(priorityCalculator, "The CommandPriorityCalculator may not be null.");
        this.routingKeyResolver = Objects.requireNonNull(routingKeyResolver, "The RoutingStrategy may not be null.");
    }

    @Override
    @Nonnull
    public CommandResult send(@Nonnull Object command, @Nonnull Metadata metadata, @Nullable ProcessingContext context) {
        return new FutureCommandResult(this.commandBus.dispatch(this.asCommandMessage(command, metadata), context));
    }

    private CommandMessage asCommandMessage(Object command, Metadata metadata) {
        CommandMessage commandMessage;
        if (command instanceof CommandMessage) {
            commandMessage = (CommandMessage)command;
        } else {
            GenericCommandMessage genericCommandMessage;
            if (command instanceof Message) {
                Message message = (Message)command;
                genericCommandMessage = new GenericCommandMessage(message.type(), message.payload(), message.metadata());
            } else {
                genericCommandMessage = new GenericCommandMessage(this.messageTypeResolver.resolveOrThrow(command), command, metadata);
            }
            commandMessage = genericCommandMessage;
        }
        return new GenericCommandMessage(commandMessage, commandMessage.routingKey().orElse(this.routingKeyResolver.getRoutingKey(commandMessage)), commandMessage.priority().orElse(this.priorityCalculator.determinePriority(commandMessage)));
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandBus", this.commandBus);
        descriptor.describeProperty("messageTypeResolver", this.messageTypeResolver);
        descriptor.describeProperty("priorityCalculator", this.priorityCalculator);
        descriptor.describeProperty("routingKeyResolver", this.routingKeyResolver);
    }
}

