/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public class ConvertingCommandGateway
implements CommandGateway {
    private final CommandGateway delegate;
    private final MessageConverter converter;

    public ConvertingCommandGateway(@Nonnull CommandGateway delegate, @Nonnull MessageConverter converter) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate must not be null.");
        this.converter = Objects.requireNonNull(converter, "The MessageConverter must not be null.");
    }

    @Override
    @Nonnull
    public CommandResult send(@Nonnull Object command, @Nonnull Metadata metadata, @Nullable ProcessingContext context) {
        return new ConvertingCommandResult(this.converter, this.delegate.send(command, metadata, context));
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("converter", this.converter);
    }

    private record ConvertingCommandResult(@Nonnull MessageConverter commandConverter, @Nonnull CommandResult delegate) implements CommandResult
    {
        ConvertingCommandResult {
            Objects.requireNonNull(commandConverter, "The MessageConverter must not be null.");
            Objects.requireNonNull(delegate, "The CommandResult must not be null.");
        }

        @Override
        public CompletableFuture<? extends Message> getResultMessage() {
            return this.delegate.getResultMessage();
        }

        @Override
        public <R> CompletableFuture<R> resultAs(@Nonnull Class<R> type) {
            return this.delegate.getResultMessage().thenApply(resultMessage -> resultMessage != null ? resultMessage.payloadAs(type, (Converter)this.commandConverter) : null);
        }

        @Override
        public <R> CommandResult onSuccess(@Nonnull Class<R> resultType, @Nonnull BiConsumer<R, Message> successHandler) {
            Objects.requireNonNull(successHandler, "The success handler must not be null.");
            this.delegate.getResultMessage().whenComplete((message, e) -> {
                if (e == null) {
                    successHandler.accept((Object)message.payloadAs(resultType, (Converter)this.commandConverter), (Message)message);
                }
            });
            return this;
        }
    }
}

