/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.SimpleCommandHandlingComponent;
import org.axonframework.commandhandling.configuration.CommandHandlingModule;
import org.axonframework.common.FutureUtils;
import org.axonframework.configuration.BaseModule;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.messaging.QualifiedName;

class SimpleCommandHandlingModule
extends BaseModule<SimpleCommandHandlingModule>
implements CommandHandlingModule,
CommandHandlingModule.SetupPhase,
CommandHandlingModule.CommandHandlerPhase {
    private final String commandHandlingComponentName;
    private final Map<QualifiedName, ComponentBuilder<CommandHandler>> handlerBuilders;
    private final List<ComponentBuilder<CommandHandlingComponent>> handlingComponentBuilders;

    SimpleCommandHandlingModule(@Nonnull String moduleName) {
        super(Objects.requireNonNull(moduleName, "The module name cannot be null."));
        this.commandHandlingComponentName = "CommandHandlingComponent[" + moduleName + "]";
        this.handlerBuilders = new HashMap<QualifiedName, ComponentBuilder<CommandHandler>>();
        this.handlingComponentBuilders = new ArrayList<ComponentBuilder<CommandHandlingComponent>>();
    }

    @Override
    public CommandHandlingModule.CommandHandlerPhase commandHandlers() {
        return this;
    }

    @Override
    public CommandHandlingModule.CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull ComponentBuilder<CommandHandler> commandHandlerBuilder) {
        this.handlerBuilders.put(Objects.requireNonNull(commandName, "The command name cannot be null."), Objects.requireNonNull(commandHandlerBuilder, "The command handler builder cannot be null."));
        return this;
    }

    @Override
    public CommandHandlingModule.CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentBuilder<CommandHandlingComponent> handlingComponentBuilder) {
        this.handlingComponentBuilders.add(Objects.requireNonNull(handlingComponentBuilder, "The command handling component builder cannot be null."));
        return this;
    }

    @Override
    public CommandHandlingModule build() {
        this.registerCommandHandlingComponent();
        return this;
    }

    private void registerCommandHandlingComponent() {
        this.componentRegistry(cr -> cr.registerComponent(this.commandHandlingComponentComponentDefinition()));
    }

    private ComponentDefinition<CommandHandlingComponent> commandHandlingComponentComponentDefinition() {
        return ComponentDefinition.ofTypeAndName(CommandHandlingComponent.class, this.commandHandlingComponentName).withBuilder(c -> {
            SimpleCommandHandlingComponent commandHandlingComponent = SimpleCommandHandlingComponent.create(this.commandHandlingComponentName);
            this.handlingComponentBuilders.forEach(handlingComponent -> commandHandlingComponent.subscribe((CommandHandlingComponent)handlingComponent.build(c)));
            this.handlerBuilders.forEach((key, value) -> commandHandlingComponent.subscribe((QualifiedName)key, (CommandHandler)value.build(c)));
            return commandHandlingComponent;
        }).onStart(0, (configuration, component) -> {
            configuration.getComponent(CommandBus.class).subscribe(configuration.getComponent(CommandHandlingComponent.class, this.commandHandlingComponentName));
            return FutureUtils.emptyCompletedFuture();
        });
    }
}

