/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.NoHandlerForQueryException;
import org.axonframework.messaging.queryhandling.QueryHandler;
import org.axonframework.messaging.queryhandling.QueryHandlerRegistry;
import org.axonframework.messaging.queryhandling.QueryHandlingComponent;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;

public class SimpleQueryHandlingComponent
implements QueryHandlingComponent,
QueryHandlerRegistry<SimpleQueryHandlingComponent>,
DescribableComponent {
    private final String name;
    private final Map<QualifiedName, QueryHandler> queryHandlers = new HashMap<QualifiedName, QueryHandler>();
    private final Set<QueryHandlingComponent> subComponents = new HashSet<QueryHandlingComponent>();

    public static SimpleQueryHandlingComponent create(@Nonnull String name) {
        return new SimpleQueryHandlingComponent(name);
    }

    private SimpleQueryHandlingComponent(@Nonnull String name) {
        this.name = Assert.nonEmpty(name, "The name may not be null or empty.");
    }

    @Override
    public SimpleQueryHandlingComponent subscribe(@Nonnull QualifiedName queryName, @Nonnull QueryHandler handler) {
        if (handler instanceof QueryHandlingComponent) {
            QueryHandlingComponent component = (QueryHandlingComponent)handler;
            return this.subscribe(component);
        }
        this.queryHandlers.put(queryName, handler);
        return this;
    }

    @Override
    public SimpleQueryHandlingComponent subscribe(@Nonnull QueryHandlingComponent handlingComponent) {
        this.subComponents.add(handlingComponent);
        return this;
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> handle(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
        QualifiedName handlerName = query.type().qualifiedName();
        Optional<QueryHandlingComponent> optionalSubHandler = this.subComponents.stream().filter(subComponent -> subComponent.supportedQueries().contains(handlerName)).findFirst();
        if (optionalSubHandler.isPresent()) {
            try {
                return optionalSubHandler.get().handle(query, context);
            }
            catch (Throwable e) {
                return MessageStream.failed(e);
            }
        }
        if (this.queryHandlers.containsKey(handlerName)) {
            try {
                return this.queryHandlers.get(handlerName).handle(query, context);
            }
            catch (Throwable e) {
                return MessageStream.failed(e);
            }
        }
        return MessageStream.failed(NoHandlerForQueryException.forHandlingComponent(query));
    }

    @Override
    public Set<QualifiedName> supportedQueries() {
        HashSet<QualifiedName> combinedNames = new HashSet<QualifiedName>(this.queryHandlers.keySet());
        this.subComponents.forEach(subComponent -> combinedNames.addAll(subComponent.supportedQueries()));
        return combinedNames;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("name", this.name);
        descriptor.describeProperty("queryHandlers", this.queryHandlers);
        descriptor.describeProperty("subComponents", this.subComponents);
    }
}

