/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring.interception;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.queryhandling.QueryMessage;

public class MonitoringQueryHandlerInterceptor
implements MessageHandlerInterceptor<QueryMessage> {
    private final MessageMonitor<? super QueryMessage> messageMonitor;

    public MonitoringQueryHandlerInterceptor(@Nonnull MessageMonitor<? super QueryMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull QueryMessage message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<QueryMessage> interceptorChain) {
        if (context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

