/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring.interception;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.monitoring.MessageMonitor;

public class MonitoringCommandHandlerInterceptor
implements MessageHandlerInterceptor<CommandMessage> {
    private final MessageMonitor<? super CommandMessage> messageMonitor;

    public MonitoringCommandHandlerInterceptor(@Nonnull MessageMonitor<? super CommandMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull CommandMessage message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<CommandMessage> interceptorChain) {
        if (context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

