/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.subscribing;

import jakarta.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.SubscribableEventSource;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorConfiguration;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorHandler;
import org.axonframework.messaging.eventhandling.tracing.EventProcessorSpanFactory;
import org.axonframework.messaging.monitoring.MessageMonitor;

public class SubscribingEventProcessorConfiguration
extends EventProcessorConfiguration {
    private SubscribableEventSource eventSource;

    @Internal
    public SubscribingEventProcessorConfiguration() {
    }

    @Internal
    public SubscribingEventProcessorConfiguration(@Nonnull EventProcessorConfiguration base) {
        super(base);
    }

    @Internal
    public SubscribingEventProcessorConfiguration(@Nonnull EventProcessorConfiguration base, @Nonnull Configuration configuration) {
        super(base);
    }

    @Override
    public SubscribingEventProcessorConfiguration errorHandler(@Nonnull ErrorHandler errorHandler) {
        super.errorHandler(errorHandler);
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration messageMonitor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        super.messageMonitor(messageMonitor);
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration spanFactory(@Nonnull EventProcessorSpanFactory spanFactory) {
        super.spanFactory(spanFactory);
        return this;
    }

    public SubscribingEventProcessorConfiguration eventSource(@Nonnull SubscribableEventSource eventSource) {
        BuilderUtils.assertNonNull(eventSource, "SubscribableEventSource may not be null");
        this.eventSource = eventSource;
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration unitOfWorkFactory(@Nonnull UnitOfWorkFactory unitOfWorkFactory) {
        super.unitOfWorkFactory(unitOfWorkFactory);
        return this;
    }

    @Nonnull
    public SubscribingEventProcessorConfiguration withInterceptor(@Nonnull MessageHandlerInterceptor<? super EventMessage> interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    protected void validate() throws AxonConfigurationException {
        super.validate();
        BuilderUtils.assertNonNull(this.eventSource, "The SubscribableMessageSource is a hard requirement and should be provided");
    }

    public SubscribableEventSource eventSource() {
        return this.eventSource;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        descriptor.describeProperty("eventSource", this.eventSource);
    }
}

