/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.segmenting;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventHandler;
import org.axonframework.messaging.eventhandling.EventHandlerRegistry;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;

@Internal
public class SequenceOverridingEventHandlingComponent
implements EventHandlingComponent {
    private final SequencingPolicy sequencingPolicy;
    private final EventHandlingComponent delegate;

    public SequenceOverridingEventHandlingComponent(@Nonnull SequencingPolicy sequencingPolicy, @Nonnull EventHandlingComponent delegate) {
        this.sequencingPolicy = Objects.requireNonNull(sequencingPolicy, "SequencingPolicy may not be null");
        this.delegate = Objects.requireNonNull(delegate, "Delegate EventHandlingComponent may not be null");
    }

    @Override
    @Nonnull
    public Object sequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(event, "Event Message may not be null");
        return this.sequencingPolicy.getSequenceIdentifierFor(event, context).orElseGet(() -> this.delegate.sequenceIdentifierFor(event, context));
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return this.delegate.supportedEvents();
    }

    @Override
    public boolean supports(@Nonnull QualifiedName eventName) {
        return this.delegate.supports(eventName);
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.delegate.handle(event, context);
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        return this.delegate.subscribe(name, eventHandler);
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler eventHandler) {
        return this.delegate.subscribe(names, eventHandler);
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull EventHandlingComponent handlingComponent) {
        return this.delegate.subscribe(handlingComponent);
    }
}

