/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.pooled;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.CoordinatorTask;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.WorkPackage;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.Segment;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.TrackerStatus;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.TokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitTask
extends CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final int segmentId;
    private final Map<Integer, WorkPackage> workPackages;
    private final Map<Integer, Instant> releasesDeadlines;
    private final TokenStore tokenStore;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private final Clock clock;

    SplitTask(CompletableFuture<Boolean> result, String name, int segmentId, Map<Integer, WorkPackage> workPackages, Map<Integer, Instant> releasesDeadlines, TokenStore tokenStore, UnitOfWorkFactory unitOfWorkFactory, Clock clock) {
        super(result, name);
        this.name = name;
        this.segmentId = segmentId;
        this.workPackages = workPackages;
        this.releasesDeadlines = releasesDeadlines;
        this.tokenStore = tokenStore;
        this.unitOfWorkFactory = unitOfWorkFactory;
        this.clock = clock;
    }

    @Override
    protected CompletableFuture<Boolean> task() {
        this.releasesDeadlines.put(this.segmentId, this.clock.instant().plusSeconds(60L));
        logger.debug("Processor [{}] will perform split instruction for segment {}.", (Object)this.name, (Object)this.segmentId);
        WorkPackage workPackage = this.workPackages.remove(this.segmentId);
        return workPackage != null ? this.abortAndSplit(workPackage) : this.fetchSegmentAndSplit(this.segmentId);
    }

    private CompletableFuture<Boolean> abortAndSplit(WorkPackage workPackage) {
        return workPackage.abort(null).thenApply(e -> this.splitAndRelease(workPackage.segment()));
    }

    private CompletableFuture<Boolean> fetchSegmentAndSplit(int segmentId) {
        return this.unitOfWorkFactory.create().executeWithResult(context -> this.tokenStore.fetchSegment(this.name, segmentId, (ProcessingContext)context).thenApply(this::splitAndRelease));
    }

    private boolean splitAndRelease(Segment segmentToSplit) {
        try {
            FutureUtils.joinAndUnwrap(this.unitOfWorkFactory.create().executeWithResult(context -> ((CompletableFuture)this.tokenStore.fetchToken(this.name, segmentToSplit.getSegmentId(), (ProcessingContext)context).thenApply(tokenToSplit -> TrackerStatus.split(segmentToSplit, tokenToSplit))).thenCompose(splitStatuses -> this.splitAndRelease((TrackerStatus[])splitStatuses, segmentToSplit, (ProcessingContext)context))));
        }
        finally {
            this.releasesDeadlines.remove(segmentToSplit.getSegmentId());
        }
        return true;
    }

    @Nonnull
    private CompletableFuture<Void> splitAndRelease(@Nonnull TrackerStatus[] splitStatuses, @Nonnull Segment segmentToSplit, @Nonnull ProcessingContext context) {
        return ((CompletableFuture)this.tokenStore.initializeSegment(splitStatuses[1].getTrackingToken(), this.name, splitStatuses[1].getSegment(), context).thenCompose(result -> this.tokenStore.releaseClaim(this.name, splitStatuses[0].getSegment().getSegmentId(), context))).thenRun(() -> logger.info("Processor [{}] successfully split {} into {} and {}.", new Object[]{this.name, segmentToSplit, splitStatuses[0].getSegment(), splitStatuses[1].getSegment()}));
    }

    @Override
    String getDescription() {
        return "Split Task for segment " + this.segmentId;
    }
}

