/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.errorhandling;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.eventhandling.processing.EventProcessingException;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorContext;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorHandler;

public enum PropagatingErrorHandler implements ErrorHandler
{
    INSTANCE;


    public static PropagatingErrorHandler instance() {
        return INSTANCE;
    }

    @Override
    public void handleError(@Nonnull ErrorContext errorContext) throws Exception {
        Throwable error = errorContext.error();
        if (error instanceof Error) {
            throw (Error)error;
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new EventProcessingException("An error occurred while handling an event.", error);
    }
}

