/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.core.Context;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventSink;
import org.axonframework.messaging.eventhandling.gateway.ProcessingContextEventAppender;

public interface EventAppender
extends DescribableComponent {
    public static final Context.ResourceKey<ProcessingContextEventAppender> RESOURCE_KEY = Context.ResourceKey.withLabel("EventAppender");

    public static EventAppender forContext(@Nonnull ProcessingContext context) {
        return EventAppender.forContext(context, context.component(EventSink.class), context.component(MessageTypeResolver.class));
    }

    public static EventAppender forContext(@Nonnull ProcessingContext context, @Nonnull EventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver) {
        Objects.requireNonNull(context, "ProcessingContext may not be null");
        return context.computeResourceIfAbsent(RESOURCE_KEY, () -> new ProcessingContextEventAppender(context, eventSink, messageTypeResolver));
    }

    default public void append(Object ... events) {
        this.append(Arrays.asList(events));
    }

    public void append(@Nonnull List<?> var1);
}

