/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.core.EmptyApplicationContext;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.interception.HandlerInterceptorRegistry;
import org.axonframework.messaging.core.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorHandler;
import org.axonframework.messaging.eventhandling.processing.errorhandling.PropagatingErrorHandler;
import org.axonframework.messaging.eventhandling.tracing.DefaultEventProcessorSpanFactory;
import org.axonframework.messaging.eventhandling.tracing.EventProcessorSpanFactory;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.monitoring.NoOpMessageMonitor;
import org.axonframework.messaging.monitoring.configuration.MessageMonitorRegistry;
import org.axonframework.messaging.tracing.NoOpSpanFactory;

public class EventProcessorConfiguration
implements DescribableComponent {
    protected ErrorHandler errorHandler = PropagatingErrorHandler.INSTANCE;
    protected MessageMonitor<? super EventMessage> messageMonitor = NoOpMessageMonitor.INSTANCE;
    protected EventProcessorSpanFactory spanFactory = DefaultEventProcessorSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();
    protected UnitOfWorkFactory unitOfWorkFactory = new SimpleUnitOfWorkFactory(EmptyApplicationContext.INSTANCE);
    protected List<MessageHandlerInterceptor<? super EventMessage>> interceptors = new ArrayList<MessageHandlerInterceptor<? super EventMessage>>();

    @Internal
    public EventProcessorConfiguration() {
    }

    @Internal
    public EventProcessorConfiguration(@Nonnull Configuration configuration) {
        this.interceptors = configuration.getComponent(HandlerInterceptorRegistry.class).eventInterceptors(configuration);
        this.messageMonitor(configuration.getComponent(MessageMonitorRegistry.class).eventMonitor(configuration));
    }

    @Internal
    public EventProcessorConfiguration(@Nonnull EventProcessorConfiguration base) {
        Objects.requireNonNull(base, "Base configuration may not be null");
        BuilderUtils.assertNonNull(base, "Base configuration may not be null");
        this.errorHandler = base.errorHandler();
        this.messageMonitor = base.messageMonitor();
        this.spanFactory = base.spanFactory();
        this.unitOfWorkFactory = base.unitOfWorkFactory();
        this.interceptors = base.interceptors();
    }

    public EventProcessorConfiguration errorHandler(@Nonnull ErrorHandler errorHandler) {
        BuilderUtils.assertNonNull(errorHandler, "ErrorHandler may not be null");
        this.errorHandler = errorHandler;
        return this;
    }

    public EventProcessorConfiguration messageMonitor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
        this.messageMonitor = messageMonitor;
        return this;
    }

    public EventProcessorConfiguration spanFactory(@Nonnull EventProcessorSpanFactory spanFactory) {
        BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
        this.spanFactory = spanFactory;
        return this;
    }

    public EventProcessorConfiguration unitOfWorkFactory(@Nonnull UnitOfWorkFactory unitOfWorkFactory) {
        BuilderUtils.assertNonNull(unitOfWorkFactory, "UnitOfWorkFactory may not be null");
        this.unitOfWorkFactory = unitOfWorkFactory;
        return this;
    }

    protected void validate() throws AxonConfigurationException {
        BuilderUtils.assertNonNull(this.unitOfWorkFactory, "The UnitOfWorkFactory is a hard requirement and should be provided");
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public MessageMonitor<? super EventMessage> messageMonitor() {
        return this.messageMonitor;
    }

    public EventProcessorSpanFactory spanFactory() {
        return this.spanFactory;
    }

    public UnitOfWorkFactory unitOfWorkFactory() {
        return this.unitOfWorkFactory;
    }

    public List<MessageHandlerInterceptor<? super EventMessage>> interceptors() {
        return new ArrayList<MessageHandlerInterceptor<? super EventMessage>>(this.interceptors);
    }

    public boolean streaming() {
        return false;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("errorHandler", this.errorHandler);
        descriptor.describeProperty("messageMonitor", this.messageMonitor);
        descriptor.describeProperty("spanFactory", this.spanFactory);
        descriptor.describeProperty("unitOfWorkFactory", this.unitOfWorkFactory);
        descriptor.describeProperty("interceptors", this.interceptors);
    }
}

