/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.annotation;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.annotation.Timestamp;

@Priority(value=0x3FFFFFFF)
public final class TimestampParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<Timestamp, Instant> {
    private final ParameterResolver<Instant> resolver = new TimestampParameterResolver();

    public TimestampParameterResolverFactory() {
        super(Timestamp.class, Instant.class);
    }

    @Override
    protected ParameterResolver<Instant> getResolver() {
        return this.resolver;
    }

    static class TimestampParameterResolver
    implements ParameterResolver<Instant> {
        TimestampParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<Instant> resolveParameterValue(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message instanceof EventMessage) {
                EventMessage eventMessage = (EventMessage)message;
                return CompletableFuture.completedFuture(eventMessage.timestamp());
            }
            return FutureUtils.emptyCompletedFuture();
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

