/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.core.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.core.annotation.HandlerDefinition;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.interception.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventHandler;
import org.axonframework.messaging.eventhandling.EventHandlerRegistry;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.SimpleEventHandlingComponent;
import org.axonframework.messaging.eventhandling.annotation.EventHandlingMember;
import org.axonframework.messaging.eventhandling.annotation.MethodEventHandlerDefinition;
import org.axonframework.messaging.eventhandling.annotation.MethodSequencingPolicyEventHandlerDefinition;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;

public class AnnotatedEventHandlingComponent<T>
implements EventHandlingComponent {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final EventHandlingComponent delegate;

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory) {
        this(annotatedEventHandler, parameterResolverFactory, new SimpleEventHandlingComponent(), ClasspathHandlerDefinition.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull EventHandlingComponent delegate) {
        this(annotatedEventHandler, parameterResolverFactory, delegate, ClasspathHandlerDefinition.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull EventHandlingComponent delegate, @Nonnull HandlerDefinition handlerDefinition) {
        this(annotatedEventHandler, delegate, AnnotatedHandlerInspector.inspectType(annotatedEventHandler.getClass(), parameterResolverFactory, handlerDefinition));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull EventHandlingComponent delegate, @Nonnull AnnotatedHandlerInspector<T> model) {
        this.target = Objects.requireNonNull(annotatedEventHandler, "The Annotated Event Handler may not be null");
        this.model = Objects.requireNonNull(model, "The Annotated Handler Inspector may not be null");
        this.delegate = delegate;
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(h -> h.canHandleMessageType(EventMessage.class)).forEach(this::registerHandler));
    }

    private void registerHandler(MessageHandlingMember<? super T> handler) {
        Class<?> payloadType = handler.payloadType();
        QualifiedName qualifiedName = handler.unwrap(MethodEventHandlerDefinition.MethodEventMessageHandlingMember.class).map(EventHandlingMember::eventName).map(QualifiedName::new).orElseGet(() -> new QualifiedName(payloadType));
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        this.delegate.subscribe(qualifiedName, this.interceptedEventHandler(qualifiedName, handler, interceptorChain));
    }

    @Nonnull
    private EventHandler interceptedEventHandler(QualifiedName qualifiedName, MessageHandlingMember<? super T> handler, MessageHandlerInterceptorMemberChain<T> interceptorChain) {
        EventHandler interceptedEventHandler = (event, ctx) -> interceptorChain.handle(event.withConvertedPayload((Class)handler.payloadType(), (Converter)ctx.component(EventConverter.class)), ctx, this.target, handler).ignoreEntries().cast();
        Optional<SequencingPolicy> sequencingPolicy = handler.unwrap(MethodSequencingPolicyEventHandlerDefinition.SequencingPolicyEventMessageHandlingMember.class).map(MethodSequencingPolicyEventHandlerDefinition.SequencingPolicyEventMessageHandlingMember::sequencingPolicy);
        return sequencingPolicy.map(sp -> new SimpleEventHandlingComponent((SequencingPolicy)sp).subscribe(qualifiedName, interceptedEventHandler)).orElse(interceptedEventHandler);
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        return this.delegate.subscribe(name, eventHandler);
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.delegate.handle(event, context);
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.delegate.supportedEvents());
    }

    @Override
    @Nonnull
    public Object sequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.delegate.sequenceIdentifierFor(event, context);
    }
}

