/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.common.Registration;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventBus;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.InterceptingEventSink;

@Internal
public class InterceptingEventBus
implements EventBus {
    public static final int DECORATION_ORDER = -2147483548;
    private final EventBus delegate;
    private final List<MessageDispatchInterceptor<? super EventMessage>> interceptors;
    private final InterceptingEventSink delegateSink;

    @Internal
    public InterceptingEventBus(@Nonnull EventBus delegate, @Nonnull List<MessageDispatchInterceptor<? super EventMessage>> interceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The EventBus may not be null.");
        this.interceptors = Objects.requireNonNull(interceptors, "The dispatch interception must not be null.");
        this.delegateSink = new InterceptingEventSink(delegate, interceptors);
    }

    @Override
    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.delegateSink.publish(context, events);
    }

    @Override
    public Registration subscribe(@Nonnull BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>> eventsBatchConsumer) {
        return this.delegate.subscribe(eventsBatchConsumer);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("dispatchInterceptors", this.interceptors);
        descriptor.describeProperty("delegateSink", this.delegateSink);
    }
}

