/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.unitofwork.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Priority(value=-1073741824)
public class ProcessingContextParameterResolverFactory
implements ParameterResolverFactory {
    private static final ProcessingContextParameterResolver INSTANCE = new ProcessingContextParameterResolver();

    @Nullable
    public ParameterResolver<ProcessingContext> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (parameter.getType().isAssignableFrom(ProcessingContext.class)) {
            return INSTANCE;
        }
        return null;
    }

    private static class ProcessingContextParameterResolver
    implements ParameterResolver<ProcessingContext> {
        private ProcessingContextParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<ProcessingContext> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(context);
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return true;
        }
    }
}

