/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.interception;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageDispatchInterceptorChain;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.interception.JSR303ViolationException;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public class BeanValidationInterceptor<M extends Message>
implements MessageHandlerInterceptor<M>,
MessageDispatchInterceptor<M> {
    private final ValidatorFactory validatorFactory;

    public BeanValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public BeanValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull M message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<M> dispatchInterceptorChain) {
        return this.interceptOrContinue(message, m -> dispatchInterceptorChain.proceed(m, context));
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<M> handlerInterceptorChain) {
        return this.interceptOrContinue(message, m -> handlerInterceptorChain.proceed(m, context));
    }

    @Nonnull
    private MessageStream<?> interceptOrContinue(@Nonnull M message, @Nonnull Function<M, MessageStream<?>> continuation) {
        Set<ConstraintViolation<Object>> violations = this.validate((Message)message);
        if (!violations.isEmpty()) {
            return MessageStream.fromFuture(CompletableFuture.failedFuture(new JSR303ViolationException(violations)));
        }
        return continuation.apply(message);
    }

    private Set<ConstraintViolation<Object>> validate(Message message) {
        Validator validator = this.validatorFactory.getValidator();
        return this.validateMessage(message.payload(), validator);
    }

    protected Set<ConstraintViolation<Object>> validateMessage(Object message, Validator validator) {
        return validator.validate(message, new Class[0]);
    }
}

