/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.axonframework.messaging.core.annotation.HandlerDefinition;
import org.axonframework.messaging.core.annotation.MultiHandlerDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathHandlerDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathHandlerDefinition.class);
    private static final Object MONITOR = new Object();
    private static final Map<ClassLoader, WeakReference<MultiHandlerDefinition>> FACTORIES = new WeakHashMap<ClassLoader, WeakReference<MultiHandlerDefinition>>();

    private ClasspathHandlerDefinition() {
    }

    public static MultiHandlerDefinition forClass(Class<?> clazz) {
        return ClasspathHandlerDefinition.forClassLoader(clazz == null ? null : clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiHandlerDefinition forClassLoader(ClassLoader classLoader) {
        Object object = MONITOR;
        synchronized (object) {
            if (!FACTORIES.containsKey(classLoader)) {
                MultiHandlerDefinition handlerDefinition = MultiHandlerDefinition.ordered(ClasspathHandlerDefinition.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<MultiHandlerDefinition>(handlerDefinition));
                return handlerDefinition;
            }
            MultiHandlerDefinition handlerDefinition = (MultiHandlerDefinition)FACTORIES.get(classLoader).get();
            if (handlerDefinition == null) {
                handlerDefinition = MultiHandlerDefinition.ordered(ClasspathHandlerDefinition.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<MultiHandlerDefinition>(handlerDefinition));
            }
            return handlerDefinition;
        }
    }

    private static MultiHandlerDefinition findDelegates(ClassLoader classLoader) {
        Iterator<HandlerDefinition> iterator = ServiceLoader.load(HandlerDefinition.class, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).iterator();
        ArrayList<HandlerDefinition> definitions = new ArrayList<HandlerDefinition>();
        while (iterator.hasNext()) {
            try {
                HandlerDefinition factory = iterator.next();
                definitions.add(factory);
            }
            catch (ServiceConfigurationError e) {
                LOGGER.info("HandlerDefinition instance ignored, as one of the required classes is not availableon the classpath: {}", (Object)e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                LOGGER.info("HandlerDefinition instance ignored. It relies on a class that cannot be found: {}", (Object)e.getMessage());
            }
        }
        return new MultiHandlerDefinition(definitions);
    }
}

