/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.Metadata;

public abstract class MessageDecorator
implements Message {
    private final Message delegate;

    protected MessageDecorator(@Nonnull Message delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.delegate.identifier();
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.delegate.type();
    }

    @Override
    @Nullable
    public Object payload() {
        return this.delegate.payload();
    }

    @Override
    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        return this.delegate.payloadAs(type, converter);
    }

    @Override
    @Nonnull
    public Class<?> payloadType() {
        return this.delegate.payloadType();
    }

    @Override
    @Nonnull
    public Metadata metadata() {
        return this.delegate.metadata();
    }

    @Override
    @Nonnull
    public Message withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        return this.delegate.withConvertedPayload(type, converter);
    }

    @Nonnull
    protected Message delegate() {
        return this.delegate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.describeType()).append("{");
        this.describeTo(sb);
        return sb.append("}").toString();
    }

    protected void describeTo(StringBuilder stringBuilder) {
        stringBuilder.append("type={").append(this.type()).append('}').append(", payload={").append(this.payload()).append('}').append(", metadata={").append(this.metadata()).append('}').append(", messageIdentifier='").append(this.identifier()).append('\'');
    }

    protected String describeType() {
        return this.getClass().getSimpleName();
    }
}

