/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.gateway.CommandDispatcher;
import org.axonframework.messaging.commandhandling.gateway.CommandGateway;
import org.axonframework.messaging.commandhandling.gateway.CommandResult;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Internal
public class ContextAwareCommandDispatcher
implements CommandDispatcher {
    private final CommandGateway commandGateway;
    private final ProcessingContext context;

    ContextAwareCommandDispatcher(@Nonnull CommandGateway commandGateway, @Nonnull ProcessingContext context) {
        this.commandGateway = Objects.requireNonNull(commandGateway, "The Command Gateway must not be null.");
        this.context = Objects.requireNonNull(context, "The Processing Context must not be null.");
    }

    @Override
    public CommandResult send(@Nonnull Object command) {
        return this.commandGateway.send(command, this.context);
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nonnull Metadata metadata) {
        return this.commandGateway.send(command, metadata, this.context);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("processingContext", this.context);
        descriptor.describeProperty("commandGateway", this.commandGateway);
    }
}

