/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ComponentDecorator;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.DecoratorDefinition;
import org.axonframework.common.configuration.SearchScope;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.distributed.CommandBusConnector;
import org.axonframework.messaging.commandhandling.distributed.DistributedCommandBus;
import org.axonframework.messaging.commandhandling.distributed.DistributedCommandBusConfiguration;

@Internal
public class DistributedCommandBusConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int DISTRIBUTED_COMMAND_BUS_ORDER = -2147483598;

    @Override
    public void enhance(@Nonnull ComponentRegistry componentRegistry) {
        if (componentRegistry.hasComponent(CommandBusConnector.class)) {
            componentRegistry.registerIfNotPresent(DistributedCommandBusConfiguration.class, c -> DistributedCommandBusConfiguration.DEFAULT, SearchScope.ALL).registerDecorator(DecoratorDefinition.forType(CommandBus.class).with(this.commandBusDecoratorDefinition()).order(-2147483598));
        }
    }

    private ComponentDecorator<CommandBus, CommandBus> commandBusDecoratorDefinition() {
        return (config, name, delegate) -> {
            if (delegate instanceof DistributedCommandBus) {
                return delegate;
            }
            DistributedCommandBusConfiguration commandBusConfiguration = config.getComponent(DistributedCommandBusConfiguration.class);
            return config.getOptionalComponent(CommandBusConnector.class).map(connector -> new DistributedCommandBus((CommandBus)delegate, (CommandBusConnector)connector, commandBusConfiguration)).orElse((CommandBus)delegate);
        };
    }
}

