/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.conversion.ChainingContentTypeConverter;
import org.axonframework.conversion.ConversionException;
import org.axonframework.conversion.Converter;
import org.axonframework.conversion.json.ByteArrayToJsonNodeConverter;
import org.axonframework.conversion.json.JsonNodeToByteArrayConverter;
import org.axonframework.conversion.json.JsonNodeToObjectNodeConverter;
import org.axonframework.conversion.json.ObjectNodeToJsonNodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(JacksonConverter.class);
    private final ObjectMapper objectMapper;
    private final ChainingContentTypeConverter converter;

    public JacksonConverter() {
        this(new ObjectMapper().findAndRegisterModules());
    }

    public JacksonConverter(@Nonnull ObjectMapper objectMapper) {
        this(objectMapper, new ChainingContentTypeConverter());
    }

    @Internal
    public JacksonConverter(@Nonnull ObjectMapper objectMapper, @Nonnull ChainingContentTypeConverter converter) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "The ObjectMapper may not be null.");
        this.converter = Objects.requireNonNull(converter, "The ChainingContentTypeConverter may not be null.");
        this.converter.registerConverter(new JsonNodeToByteArrayConverter(this.objectMapper));
        this.converter.registerConverter(new ByteArrayToJsonNodeConverter(this.objectMapper));
        this.converter.registerConverter(new JsonNodeToObjectNodeConverter());
        this.converter.registerConverter(new ObjectNodeToJsonNodeConverter());
    }

    @Override
    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        if (logger.isTraceEnabled()) {
            logger.trace("Validating if we can convert from source type [{}] to target type [{}].", (Object)sourceType, (Object)targetType);
        }
        return sourceType.equals(targetType) || this.converter.canConvert(sourceType, targetType) || this.converter.canConvert(sourceType, (Type)((Object)byte[].class)) || this.converter.canConvert((Type)((Object)byte[].class), targetType);
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        if (input == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Input to convert is null, so returning null immediately.");
            }
            return null;
        }
        Class<?> sourceType = input.getClass();
        if (sourceType.equals(targetType)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Casting given input since source and target type are identical.");
            }
            return (T)input;
        }
        try {
            JavaType targetJavaType = this.objectMapper.constructType(targetType);
            if (this.converter.canConvert(sourceType, targetJavaType.getRawClass())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Converter [{}] will do the entire conversion from source [{}] to target [{}] for [{}].", new Object[]{this.converter, sourceType, targetType, input});
                }
                return this.converter.convert(input, targetJavaType.getRawClass());
            }
            if (this.converter.canConvert(sourceType, byte[].class)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Converts input [{}] to byte[] before reading it into [{}].", input, (Object)targetJavaType);
                }
                return (T)this.objectMapper.readValue(this.converter.convert(input, byte[].class), targetJavaType);
            }
            if (this.converter.canConvert(byte[].class, targetJavaType.getRawClass())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Writes input [{}] as a byte[] before converting to [{}].", input, (Object)targetJavaType);
                }
                return this.converter.convert((Object)this.objectMapper.writeValueAsBytes(input), targetJavaType.getRawClass());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("ObjectMapper [{}] will convert input [{}] to target type [{}].", new Object[]{this.objectMapper, input, targetJavaType});
            }
            return (T)this.objectMapper.convertValue(input, targetJavaType);
        }
        catch (IOException e) {
            throw new ConversionException("Exception when trying to convert object of type '" + sourceType.getTypeName() + "' to '" + targetType.getTypeName() + "'", e);
        }
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("objectMapper", this.objectMapper);
        descriptor.describeProperty("chaining-content-type-converter", this.converter);
    }
}

