/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.common;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.annotations.Internal;

@Internal
public class DelayedTask {
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile boolean failed = false;
    private Exception failureCause = null;
    private final Thread thread;

    private DelayedTask(@Nonnull Runnable runnable, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay must be non-negative.");
        }
        Objects.requireNonNull(runnable, "The runnable must not be null.");
        this.thread = Thread.ofVirtual().name("AxonIQ").start(() -> {
            try {
                Thread.sleep(delay);
                this.started = true;
                runnable.run();
            }
            catch (Exception e) {
                this.failed = true;
                this.failureCause = e;
            }
            finally {
                this.finished = true;
            }
        });
    }

    public static DelayedTask of(@Nonnull Runnable runnable, long delay) {
        return new DelayedTask(runnable, delay);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Exception getFailureCause() {
        return this.failureCause;
    }

    public void cancel() {
        this.thread.interrupt();
    }
}

