/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.api;

import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.axonframework.common.annotations.Internal;
import org.axonframework.updates.api.Artifact;

@Internal
public record UpdateCheckRequest(@Nonnull String machineId, @Nonnull String instanceId, @Nonnull String osName, @Nonnull String osVersion, @Nonnull String osArch, @Nonnull String jvmVersion, @Nonnull String jvmVendor, @Nonnull String kotlinVersion, @Nonnull List<Artifact> libraries) {
    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("os=").append(this.encode(this.osName + "; " + this.osVersion + "; " + this.osArch)).append("&java=").append(this.encode(this.jvmVersion + "; " + this.jvmVendor)).append("&kotlin=").append(this.encode(this.kotlinVersion));
        for (Artifact library : this.libraries) {
            sb.append("&lib-").append(library.shortGroupId()).append(".").append(library.artifactId()).append("=").append(this.encode(library.version()));
        }
        return sb.toString();
    }

    private String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public String toUserAgent() {
        String axonBaseVersion = this.getAxonBaseVersion();
        return String.format("AxonIQ UpdateChecker/%s (Java %s %s; %s; %s; %s)", axonBaseVersion, this.jvmVersion, this.jvmVendor, this.osName, this.osVersion, this.osArch);
    }

    @Nonnull
    private String getAxonBaseVersion() {
        return this.libraries.stream().filter(a -> a.groupId().equals("org.axonframework")).filter(a -> a.artifactId().equals("axon-messaging")).map(Artifact::version).findFirst().orElse("4.12.0");
    }
}

