/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.message.SchemaStore;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.ConversionException;
import org.axonframework.serialization.avro.AvroUtil;

public class ByteArrayToGenericRecordConverter
implements ContentTypeConverter<byte[], GenericRecord> {
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private final SchemaStore schemaStore;

    public ByteArrayToGenericRecordConverter(@Nonnull SchemaStore schemaStore) {
        this.schemaStore = Objects.requireNonNull(schemaStore, "The SchemaStore may not be null.");
    }

    @Override
    @Nonnull
    public Class<byte[]> expectedSourceType() {
        return byte[].class;
    }

    @Override
    @Nonnull
    public Class<GenericRecord> targetType() {
        return GenericRecord.class;
    }

    @Override
    @Nullable
    public GenericRecord convert(@Nullable byte[] input) {
        if (input == null) {
            return null;
        }
        long fingerprint = AvroUtil.fingerprint(input);
        Schema writerSchema = this.schemaStore.findByFingerprint(fingerprint);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, writerSchema, AvroUtil.genericData);
        try {
            return (GenericRecord)reader.read(null, (Decoder)decoderFactory.binaryDecoder(AvroUtil.payload(input), null));
        }
        catch (IOException e) {
            throw new ConversionException("Cannot convert bytes to GenericRecord.", e);
        }
    }
}

