/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.serialization.Converter;

public final class PassThroughConverter
implements Converter {
    public static final PassThroughConverter INSTANCE = new PassThroughConverter();
    public static final MessageConverter MESSAGE_INSTANCE = new DelegatingMessageConverter(INSTANCE);
    public static final EventConverter EVENT_INSTANCE = new DelegatingEventConverter(MESSAGE_INSTANCE);

    private PassThroughConverter() {
    }

    @Override
    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        return sourceType.equals(targetType);
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        if (input == null) {
            return null;
        }
        Class<?> sourceType = input.getClass();
        if (sourceType.equals(targetType)) {
            return (T)input;
        }
        throw new IllegalArgumentException("This Converter only supports same-type conversion, while the unidentical source type [" + String.valueOf(sourceType) + "] and target type [" + targetType.getTypeName() + "] have been given.");
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
    }
}

