/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring.interceptors;

import jakarta.annotation.Nonnull;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.monitoring.MessageMonitor;

public class MonitoringEventHandlerInterceptor
implements MessageHandlerInterceptor<EventMessage> {
    private final MessageMonitor<? super EventMessage> messageMonitor;

    public MonitoringEventHandlerInterceptor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull EventMessage message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<EventMessage> interceptorChain) {
        if (context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

