/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.configuration;

import jakarta.annotation.Nonnull;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerRegistry;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlerName;
import org.axonframework.queryhandling.QueryHandlerRegistry;
import org.axonframework.queryhandling.QueryHandlingComponent;

public interface MessageHandlingComponent
extends CommandHandlingComponent,
CommandHandlerRegistry<MessageHandlingComponent>,
EventHandlingComponent,
QueryHandlingComponent,
QueryHandlerRegistry<MessageHandlingComponent>,
MessageHandler {
    default public MessageHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull MessageHandler handler) {
        names.forEach(n -> this.subscribe((QualifiedName)n, handler));
        return this;
    }

    default public MessageHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull MessageHandler handler) {
        MessageHandler messageHandler = handler;
        Objects.requireNonNull(messageHandler);
        MessageHandler messageHandler2 = messageHandler;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MessageHandlingComponent.class, CommandHandler.class, EventHandler.class, QueryHandler.class}, (Object)messageHandler2, n)) {
            case 0: {
                MessageHandlingComponent component = (MessageHandlingComponent)messageHandler2;
                component.supportedCommands().forEach(commandName -> this.subscribe((QualifiedName)commandName, (CommandHandler)component));
                component.supportedEvents().forEach(eventName -> this.subscribe((QualifiedName)eventName, (EventHandler)component));
                component.supportedQueries().forEach(queryHandlerName -> this.subscribe((QueryHandlerName)queryHandlerName, (QueryHandler)component));
                break;
            }
            case 1: {
                CommandHandler commandHandler = (CommandHandler)messageHandler2;
                this.subscribe(name, commandHandler);
                break;
            }
            case 2: {
                EventHandler eventHandler = (EventHandler)messageHandler2;
                this.subscribe(name, eventHandler);
                break;
            }
            case 3: {
                QueryHandler queryHandler = (QueryHandler)messageHandler2;
                this.subscribe(name, (MessageHandler)queryHandler);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(handler));
            }
        }
        return this;
    }

    default public MessageHandlingComponent subscribe(@Nonnull MessageHandlingComponent handlingComponent) {
        handlingComponent.supportedCommands().forEach(commandName -> this.subscribe((QualifiedName)commandName, (CommandHandler)handlingComponent));
        handlingComponent.supportedEvents().forEach(eventName -> this.subscribe((QualifiedName)eventName, (EventHandler)handlingComponent));
        handlingComponent.supportedQueries().forEach(queryHandlerName -> this.subscribe((QueryHandlerName)queryHandlerName, (QueryHandler)handlingComponent));
        return this;
    }

    @Override
    public MessageHandlingComponent subscribe(@Nonnull QualifiedName var1, @Nonnull CommandHandler var2);

    @Override
    default public MessageHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull CommandHandler commandHandler) {
        names.forEach(name -> this.subscribe((QualifiedName)name, commandHandler));
        return this;
    }

    @Override
    public MessageHandlingComponent subscribe(@Nonnull QualifiedName var1, @Nonnull EventHandler var2);

    @Override
    default public MessageHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler eventHandler) {
        names.forEach(name -> this.subscribe((QualifiedName)name, eventHandler));
        return this;
    }

    @Override
    public MessageHandlingComponent subscribe(@Nonnull QueryHandlerName var1, @Nonnull QueryHandler var2);

    @Override
    default public MessageHandlingComponent subscribe(@Nonnull Set<QueryHandlerName> names, @Nonnull QueryHandler queryHandler) {
        names.forEach(name -> this.subscribe((QueryHandlerName)name, queryHandler));
        return this;
    }
}

