/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Context;

public record Tag(@Nonnull String key, @Nonnull String value) {
    public static final Context.ResourceKey<Set<Tag>> RESOURCE_KEY = Context.ResourceKey.withLabel("tags");

    public Tag {
        Assert.notNull(key, () -> "A Tag's key cannot be null");
        Assert.notNull(value, () -> "A Tag's value cannot be null");
    }

    public static Context addToContext(Context context, Set<Tag> tags) {
        return context.withResource(RESOURCE_KEY, tags);
    }

    public static Optional<Set<Tag>> fromContext(Context context) {
        return Optional.ofNullable(context.getResource(RESOURCE_KEY));
    }

    public static Tag of(@Nonnull String key, @Nonnull String value) {
        return new Tag(Objects.requireNonNull(key, "The key of a Tag is required."), Objects.requireNonNull(value, "The value of a Tag is required."));
    }
}

