/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.processors.streaming.token.WrappedToken;

public class MergedTrackingToken
implements TrackingToken,
WrappedToken {
    private final TrackingToken lowerSegmentToken;
    private final TrackingToken upperSegmentToken;
    private final transient boolean lowerSegmentAdvanced;
    private final transient boolean upperSegmentAdvanced;

    @JsonCreator
    @ConstructorProperties(value={"lowerSegmentToken", "upperSegmentToken"})
    public MergedTrackingToken(@JsonProperty(value="lowerSegmentToken") TrackingToken lowerSegmentToken, @JsonProperty(value="upperSegmentToken") TrackingToken upperSegmentToken) {
        this(lowerSegmentToken, upperSegmentToken, false, false);
    }

    public static TrackingToken merged(TrackingToken lowerSegmentToken, TrackingToken upperSegmentToken) {
        return Objects.equals(lowerSegmentToken, upperSegmentToken) ? lowerSegmentToken : new MergedTrackingToken(lowerSegmentToken, upperSegmentToken);
    }

    protected MergedTrackingToken(TrackingToken lowerSegmentToken, TrackingToken upperSegmentToken, boolean lowerSegmentAdvanced, boolean upperSegmentAdvanced) {
        this.lowerSegmentToken = lowerSegmentToken;
        this.upperSegmentToken = upperSegmentToken;
        this.lowerSegmentAdvanced = lowerSegmentAdvanced;
        this.upperSegmentAdvanced = upperSegmentAdvanced;
    }

    public static boolean isMergeInProgress(TrackingToken trackingToken) {
        return WrappedToken.unwrap(trackingToken, MergedTrackingToken.class).isPresent();
    }

    public static OptionalLong mergePosition(TrackingToken trackingToken) {
        return WrappedToken.unwrap(trackingToken, MergedTrackingToken.class).map(m -> m.mergePosition()).filter(p -> p != Long.MIN_VALUE).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    private long mergePosition() {
        if (this.lowerSegmentToken.position().isPresent() && this.upperSegmentToken.position().isPresent()) {
            return Math.max(MergedTrackingToken.mergePosition(this.lowerSegmentToken).orElse(this.lowerSegmentToken.position().getAsLong()), MergedTrackingToken.mergePosition(this.upperSegmentToken).orElse(this.upperSegmentToken.position().getAsLong()));
        }
        return Long.MIN_VALUE;
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        TrackingToken newUpperSegmentToken;
        TrackingToken newLowerSegmentToken = this.lowerSegmentToken == null ? null : this.lowerSegmentToken.lowerBound(other);
        TrackingToken trackingToken = newUpperSegmentToken = this.upperSegmentToken == null ? null : this.upperSegmentToken.lowerBound(other);
        if (Objects.equals(newLowerSegmentToken, newUpperSegmentToken)) {
            return newLowerSegmentToken;
        }
        return new MergedTrackingToken(newLowerSegmentToken, newUpperSegmentToken);
    }

    @Override
    public OptionalLong position() {
        if (this.lowerSegmentToken.position().isPresent() && this.upperSegmentToken.position().isPresent()) {
            return OptionalLong.of(Math.min(this.lowerSegmentToken.position().getAsLong(), this.upperSegmentToken.position().getAsLong()));
        }
        return OptionalLong.empty();
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        TrackingToken newUpperSegmentToken;
        TrackingToken newLowerSegmentToken = this.doAdvance(this.lowerSegmentToken, other);
        if (Objects.equals(newLowerSegmentToken, newUpperSegmentToken = this.doAdvance(this.upperSegmentToken, other))) {
            return newLowerSegmentToken;
        }
        return new MergedTrackingToken(newLowerSegmentToken, newUpperSegmentToken);
    }

    @Override
    public boolean covers(TrackingToken other) {
        if (this.lowerSegmentToken == null || this.upperSegmentToken == null) {
            return other == null;
        }
        return this.lowerSegmentToken.covers(other) && this.upperSegmentToken.covers(other);
    }

    @Override
    public TrackingToken advancedTo(TrackingToken newToken) {
        boolean upperSegmentAdvanced;
        TrackingToken newLowerSegmentToken = this.doAdvance(this.lowerSegmentToken, newToken);
        TrackingToken newUpperSegmentToken = this.doAdvance(this.upperSegmentToken, newToken);
        boolean lowerSegmentAdvanced = !Objects.equals(newLowerSegmentToken, this.lowerSegmentToken);
        boolean bl = upperSegmentAdvanced = !Objects.equals(newUpperSegmentToken, this.upperSegmentToken);
        if (lowerSegmentAdvanced && upperSegmentAdvanced && Objects.equals(newLowerSegmentToken, newUpperSegmentToken)) {
            return newLowerSegmentToken;
        }
        return new MergedTrackingToken(newLowerSegmentToken, newUpperSegmentToken, lowerSegmentAdvanced, upperSegmentAdvanced);
    }

    @Override
    public <R extends TrackingToken> Optional<R> unwrap(Class<R> tokenType) {
        if (tokenType.isInstance(this)) {
            return Optional.of((TrackingToken)tokenType.cast(this));
        }
        Optional<R> unwrappedLower = WrappedToken.unwrap(this.lowerSegmentToken, tokenType);
        Optional<R> unwrappedUpper = WrappedToken.unwrap(this.upperSegmentToken, tokenType);
        if (this.lowerSegmentAdvanced && unwrappedLower.isPresent()) {
            return unwrappedLower;
        }
        if (this.upperSegmentAdvanced && unwrappedUpper.isPresent()) {
            return unwrappedUpper;
        }
        if (unwrappedLower.isPresent()) {
            return unwrappedLower;
        }
        return unwrappedUpper;
    }

    private TrackingToken doAdvance(TrackingToken currentToken, TrackingToken newToken) {
        if (currentToken == null) {
            return newToken;
        }
        if (currentToken instanceof WrappedToken) {
            if (currentToken.covers(newToken)) {
                return currentToken;
            }
            return ((WrappedToken)currentToken).advancedTo(newToken);
        }
        return currentToken.upperBound(newToken);
    }

    @Override
    public TrackingToken lowerBound() {
        TrackingToken lower = WrappedToken.unwrapLowerBound(this.lowerSegmentToken);
        TrackingToken upper = WrappedToken.unwrapLowerBound(this.upperSegmentToken);
        return lower == null || upper == null ? null : lower.lowerBound(upper);
    }

    @Override
    public TrackingToken upperBound() {
        TrackingToken lower = WrappedToken.unwrapUpperBound(this.lowerSegmentToken);
        TrackingToken upper = WrappedToken.unwrapUpperBound(this.upperSegmentToken);
        return lower == null || upper == null ? null : lower.upperBound(upper);
    }

    @JsonGetter(value="lowerSegmentToken")
    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS)
    public TrackingToken lowerSegmentToken() {
        return this.lowerSegmentToken;
    }

    @JsonGetter(value="upperSegmentToken")
    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS)
    public TrackingToken upperSegmentToken() {
        return this.upperSegmentToken;
    }

    @JsonIgnore
    public boolean isLowerSegmentAdvanced() {
        return this.lowerSegmentAdvanced;
    }

    @JsonIgnore
    public boolean isUpperSegmentAdvanced() {
        return this.upperSegmentAdvanced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergedTrackingToken that = (MergedTrackingToken)o;
        return Objects.equals(this.lowerSegmentToken, that.lowerSegmentToken) && Objects.equals(this.upperSegmentToken, that.upperSegmentToken);
    }

    public int hashCode() {
        return Objects.hash(this.lowerSegmentToken, this.upperSegmentToken);
    }

    public String toString() {
        return "MergedTrackingToken{lowerSegmentToken=" + String.valueOf(this.lowerSegmentToken) + ", upperSegmentToken=" + String.valueOf(this.upperSegmentToken) + "}";
    }
}

