/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.pooled;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.eventhandling.processors.streaming.pooled.CoordinatorTask;
import org.axonframework.eventhandling.processors.streaming.pooled.WorkPackage;
import org.axonframework.eventhandling.processors.streaming.segmenting.Segment;
import org.axonframework.eventhandling.processors.streaming.segmenting.TrackerStatus;
import org.axonframework.eventhandling.processors.streaming.token.store.TokenStore;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitTask
extends CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final int segmentId;
    private final Map<Integer, WorkPackage> workPackages;
    private final TokenStore tokenStore;
    private final UnitOfWorkFactory unitOfWorkFactory;

    SplitTask(CompletableFuture<Boolean> result, String name, int segmentId, Map<Integer, WorkPackage> workPackages, TokenStore tokenStore, UnitOfWorkFactory unitOfWorkFactory) {
        super(result, name);
        this.name = name;
        this.segmentId = segmentId;
        this.workPackages = workPackages;
        this.tokenStore = tokenStore;
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    protected CompletableFuture<Boolean> task() {
        logger.debug("Processor [{}] will perform split instruction for segment {}.", (Object)this.name, (Object)this.segmentId);
        WorkPackage workPackage = this.workPackages.remove(this.segmentId);
        return workPackage != null ? this.abortAndSplit(workPackage) : this.fetchSegmentAndSplit(this.segmentId);
    }

    private CompletableFuture<Boolean> abortAndSplit(WorkPackage workPackage) {
        return workPackage.abort(null).thenApply(e -> this.splitAndRelease(workPackage.segment()));
    }

    private CompletableFuture<Boolean> fetchSegmentAndSplit(int segmentId) {
        return this.unitOfWorkFactory.create().executeWithResult(context -> this.tokenStore.fetchSegment(this.name, segmentId, (ProcessingContext)context).thenApply(this::splitAndRelease));
    }

    private boolean splitAndRelease(Segment segmentToSplit) {
        FutureUtils.joinAndUnwrap(this.unitOfWorkFactory.create().executeWithResult(context -> ((CompletableFuture)this.tokenStore.fetchToken(this.name, segmentToSplit.getSegmentId(), (ProcessingContext)context).thenApply(tokenToSplit -> TrackerStatus.split(segmentToSplit, tokenToSplit))).thenCompose(splitStatuses -> this.splitAndRelease((TrackerStatus[])splitStatuses, segmentToSplit, (ProcessingContext)context))));
        return true;
    }

    @Nonnull
    private CompletableFuture<Void> splitAndRelease(@Nonnull TrackerStatus[] splitStatuses, @Nonnull Segment segmentToSplit, @Nonnull ProcessingContext context) {
        return ((CompletableFuture)this.tokenStore.initializeSegment(splitStatuses[1].getTrackingToken(), this.name, splitStatuses[1].getSegment(), context).thenCompose(result -> this.tokenStore.releaseClaim(this.name, splitStatuses[0].getSegment().getSegmentId(), context))).thenRun(() -> logger.info("Processor [{}] successfully split {} into {} and {}.", new Object[]{this.name, segmentToSplit, splitStatuses[0].getSegment(), splitStatuses[1].getSegment()}));
    }

    @Override
    String getDescription() {
        return "Split Task for segment " + this.segmentId;
    }
}

