/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.InterceptingEventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;

public class EventBusConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void enhance(@Nonnull ComponentRegistry registry) {
        EventBusConfigurationDefaults.registerComponents(registry);
        EventBusConfigurationDefaults.registerDecorators(registry);
    }

    private static void registerComponents(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(EventBus.class, EventBusConfigurationDefaults::defaultEventBus);
    }

    private static EventBus defaultEventBus(Configuration config) {
        return new SimpleEventBus();
    }

    private static void registerDecorators(@Nonnull ComponentRegistry registry) {
        registry.registerDecorator(EventBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageDispatchInterceptor<? super EventMessage>> dispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).eventInterceptors(config);
            return dispatchInterceptors.isEmpty() ? delegate : new InterceptingEventBus((EventBus)delegate, dispatchInterceptors);
        });
    }
}

