/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandPriorityCalculator;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotations.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.ConvertingCommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.interceptors.InterceptingCommandBus;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.ConfigurationApplicationContext;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotations.AnnotationMessageTypeResolver;
import org.axonframework.messaging.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.CorrelationDataProviderRegistry;
import org.axonframework.messaging.correlation.DefaultCorrelationDataProviderRegistry;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.interceptors.DefaultDispatchInterceptorRegistry;
import org.axonframework.messaging.interceptors.DefaultHandlerInterceptorRegistry;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;
import org.axonframework.messaging.interceptors.HandlerInterceptorRegistry;
import org.axonframework.messaging.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.TransactionalUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.monitoring.configuration.DefaultMessageMonitorRegistry;
import org.axonframework.monitoring.configuration.MessageMonitorRegistry;
import org.axonframework.monitoring.interceptors.MonitoringCommandHandlerInterceptor;
import org.axonframework.monitoring.interceptors.MonitoringEventDispatchInterceptor;
import org.axonframework.monitoring.interceptors.MonitoringEventHandlerInterceptor;
import org.axonframework.monitoring.interceptors.MonitoringQueryHandlerInterceptor;
import org.axonframework.monitoring.interceptors.MonitoringSubscriptionQueryUpdateDispatchInterceptor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryPriorityCalculator;
import org.axonframework.queryhandling.QueryUpdateEmitterParameterResolverFactory;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.interceptors.InterceptingQueryBus;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.json.JacksonConverter;

public class MessagingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;
    public static final int CONVERTING_COMMAND_GATEWAY_ORDER = -2147483548;

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void enhance(@Nonnull ComponentRegistry registry) {
        MessagingConfigurationDefaults.registerComponents(registry);
        MessagingConfigurationDefaults.registerDecorators(registry);
    }

    private static void registerComponents(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(MessageTypeResolver.class, MessagingConfigurationDefaults::defaultMessageTypeResolver).registerIfNotPresent(Converter.class, c -> new JacksonConverter()).registerIfNotPresent(MessageConverter.class, MessagingConfigurationDefaults::defaultMessageConverter).registerIfNotPresent(EventConverter.class, MessagingConfigurationDefaults::defaultEventConverter).registerIfNotPresent(UnitOfWorkFactory.class, MessagingConfigurationDefaults::defaultUnitOfWorkFactory).registerIfNotPresent(CorrelationDataProviderRegistry.class, MessagingConfigurationDefaults::defaultCorrelationDataProviderRegistry).registerIfNotPresent(DispatchInterceptorRegistry.class, MessagingConfigurationDefaults::defaultDispatchInterceptorRegistry).registerIfNotPresent(HandlerInterceptorRegistry.class, MessagingConfigurationDefaults::defaultHandlerInterceptorRegistry).registerIfNotPresent(CommandBus.class, MessagingConfigurationDefaults::defaultCommandBus).registerIfNotPresent(CommandPriorityCalculator.class, c -> CommandPriorityCalculator.defaultCalculator()).registerIfNotPresent(RoutingStrategy.class, MessagingConfigurationDefaults::defaultRoutingStrategy).registerIfNotPresent(CommandGateway.class, MessagingConfigurationDefaults::defaultCommandGateway).registerIfNotPresent(EventGateway.class, MessagingConfigurationDefaults::defaultEventGateway).registerIfNotPresent(QueryBus.class, MessagingConfigurationDefaults::defaultQueryBus).registerIfNotPresent(QueryPriorityCalculator.class, c -> QueryPriorityCalculator.defaultCalculator()).registerIfNotPresent(QueryGateway.class, MessagingConfigurationDefaults::defaultQueryGateway).registerIfNotPresent(MessageMonitorRegistry.class, MessagingConfigurationDefaults::defaultMessageMonitorRegistry);
        ParameterResolverFactoryUtils.registerToComponentRegistry(registry, config -> new QueryUpdateEmitterParameterResolverFactory());
    }

    private static MessageTypeResolver defaultMessageTypeResolver(Configuration config) {
        return new AnnotationMessageTypeResolver();
    }

    private static DelegatingMessageConverter defaultMessageConverter(Configuration c) {
        return new DelegatingMessageConverter(c.getComponent(Converter.class));
    }

    private static DelegatingEventConverter defaultEventConverter(Configuration c) {
        return c.getOptionalComponent(MessageConverter.class).map(DelegatingEventConverter::new).orElse(new DelegatingEventConverter(c.getComponent(Converter.class)));
    }

    private static UnitOfWorkFactory defaultUnitOfWorkFactory(Configuration config) {
        return new TransactionalUnitOfWorkFactory(config.getComponent(TransactionManager.class, NoTransactionManager::instance), new SimpleUnitOfWorkFactory(new ConfigurationApplicationContext(config)));
    }

    private static CorrelationDataProviderRegistry defaultCorrelationDataProviderRegistry(Configuration config) {
        return new DefaultCorrelationDataProviderRegistry().registerProvider(c -> new MessageOriginProvider());
    }

    private static DispatchInterceptorRegistry defaultDispatchInterceptorRegistry(Configuration config) {
        DispatchInterceptorRegistry dispatchInterceptorRegistry = new DefaultDispatchInterceptorRegistry();
        dispatchInterceptorRegistry = MessagingConfigurationDefaults.registerMonitoringDispatchInterceptors(dispatchInterceptorRegistry, config);
        List<CorrelationDataProvider> providers = config.getComponent(CorrelationDataProviderRegistry.class).correlationDataProviders(config);
        if (!providers.isEmpty()) {
            dispatchInterceptorRegistry = dispatchInterceptorRegistry.registerInterceptor(c -> new CorrelationDataInterceptor(providers));
        }
        return dispatchInterceptorRegistry;
    }

    private static HandlerInterceptorRegistry defaultHandlerInterceptorRegistry(Configuration config) {
        HandlerInterceptorRegistry handlerInterceptorRegistry = new DefaultHandlerInterceptorRegistry();
        handlerInterceptorRegistry = MessagingConfigurationDefaults.registerMonitoringHandlerInterceptors(handlerInterceptorRegistry, config);
        List<CorrelationDataProvider> providers = config.getComponent(CorrelationDataProviderRegistry.class).correlationDataProviders(config);
        if (!providers.isEmpty()) {
            handlerInterceptorRegistry = handlerInterceptorRegistry.registerInterceptor(c -> new CorrelationDataInterceptor(providers));
        }
        return handlerInterceptorRegistry;
    }

    private static CommandBus defaultCommandBus(Configuration config) {
        return new SimpleCommandBus(config.getComponent(UnitOfWorkFactory.class), config.getOptionalComponent(TransactionManager.class).map(tm -> tm).map(List::of).orElse(Collections.emptyList()));
    }

    private static RoutingStrategy defaultRoutingStrategy(Configuration config) {
        return new AnnotationRoutingStrategy();
    }

    private static CommandGateway defaultCommandGateway(Configuration config) {
        return new DefaultCommandGateway(config.getComponent(CommandBus.class), config.getComponent(MessageTypeResolver.class), config.getComponent(CommandPriorityCalculator.class), config.getComponent(RoutingStrategy.class));
    }

    private static EventGateway defaultEventGateway(Configuration config) {
        return new DefaultEventGateway(config.getComponent(EventSink.class), config.getComponent(MessageTypeResolver.class));
    }

    private static QueryGateway defaultQueryGateway(Configuration config) {
        return new DefaultQueryGateway(config.getComponent(QueryBus.class), config.getComponent(MessageTypeResolver.class), config.getComponent(QueryPriorityCalculator.class), config.getComponent(MessageConverter.class));
    }

    private static QueryBus defaultQueryBus(Configuration config) {
        return new SimpleQueryBus(config.getComponent(UnitOfWorkFactory.class));
    }

    private static MessageMonitorRegistry defaultMessageMonitorRegistry(Configuration config) {
        return new DefaultMessageMonitorRegistry();
    }

    private static void registerDecorators(@Nonnull ComponentRegistry registry) {
        registry.registerDecorator(CommandGateway.class, -2147483548, (config, name, delegate) -> new ConvertingCommandGateway((CommandGateway)delegate, config.getComponent(MessageConverter.class)));
        registry.registerDecorator(CommandBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageHandlerInterceptor<? super CommandMessage>> handlerInterceptors = config.getComponent(HandlerInterceptorRegistry.class).commandInterceptors(config);
            List<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).commandInterceptors(config);
            return handlerInterceptors.isEmpty() && dispatchInterceptors.isEmpty() ? delegate : new InterceptingCommandBus((CommandBus)delegate, handlerInterceptors, dispatchInterceptors);
        });
        registry.registerDecorator(QueryBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageHandlerInterceptor<? super QueryMessage>> handlerInterceptors = config.getComponent(HandlerInterceptorRegistry.class).queryInterceptors(config);
            List<MessageDispatchInterceptor<? super QueryMessage>> dispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).queryInterceptors(config);
            List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> updateDispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).subscriptionQueryUpdateInterceptors(config);
            return handlerInterceptors.isEmpty() && dispatchInterceptors.isEmpty() && updateDispatchInterceptors.isEmpty() ? delegate : new InterceptingQueryBus((QueryBus)delegate, handlerInterceptors, dispatchInterceptors, updateDispatchInterceptors);
        });
    }

    private static DispatchInterceptorRegistry registerMonitoringDispatchInterceptors(@Nonnull DispatchInterceptorRegistry dispatchInterceptorRegistry, @Nonnull Configuration config) {
        MessageMonitorRegistry messageMonitorRegistry = config.getComponent(MessageMonitorRegistry.class);
        UnaryOperator eventDispatcher = Optional.of(messageMonitorRegistry.eventMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringEventDispatchInterceptor::new).map(it -> r -> r.registerEventInterceptor(c -> it)).orElse(UnaryOperator.identity());
        UnaryOperator subscriptionQueryUpdateDispatcher = Optional.of(messageMonitorRegistry.subscriptionQueryUpdateMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringSubscriptionQueryUpdateDispatchInterceptor::new).map(it -> r -> r.registerSubscriptionQueryUpdateInterceptor(c -> it)).orElse(UnaryOperator.identity());
        return (DispatchInterceptorRegistry)eventDispatcher.andThen(subscriptionQueryUpdateDispatcher).apply(dispatchInterceptorRegistry);
    }

    private static HandlerInterceptorRegistry registerMonitoringHandlerInterceptors(@Nonnull HandlerInterceptorRegistry handlerInterceptorRegistry, @Nonnull Configuration config) {
        MessageMonitorRegistry messageMonitorRegistry = config.getComponent(MessageMonitorRegistry.class);
        UnaryOperator commandDispatcher = Optional.of(messageMonitorRegistry.commandMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringCommandHandlerInterceptor::new).map(it -> r -> r.registerCommandInterceptor(c -> it)).orElse(UnaryOperator.identity());
        UnaryOperator eventDispatcher = Optional.of(messageMonitorRegistry.eventMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringEventHandlerInterceptor::new).map(it -> r -> r.registerEventInterceptor(c -> it)).orElse(UnaryOperator.identity());
        UnaryOperator queryDispatcher = Optional.of(messageMonitorRegistry.queryMonitor(config)).filter(it -> NoOpMessageMonitor.INSTANCE != it).map(MonitoringQueryHandlerInterceptor::new).map(it -> r -> r.registerQueryInterceptor(c -> it)).orElse(UnaryOperator.identity());
        return (HandlerInterceptorRegistry)commandDispatcher.andThen(eventDispatcher).andThen(queryDispatcher).apply(handlerInterceptorRegistry);
    }
}

