/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypeReflectionUtils.class);

    public static Type getExactSuperType(Type type, Class<?> searchClass) {
        Type[] exactDirectSuperTypes;
        if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
            Class<?> clazz = TypeReflectionUtils.erase(type);
            if (searchClass.equals(clazz)) {
                return type;
            }
            if (!searchClass.isAssignableFrom(clazz)) {
                return null;
            }
        }
        for (Type superType : exactDirectSuperTypes = TypeReflectionUtils.getExactDirectSuperTypes(type)) {
            Type result = TypeReflectionUtils.getExactSuperType(superType, searchClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return tv.getBounds().length == 0 ? Object.class : TypeReflectionUtils.erase(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(TypeReflectionUtils.erase(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        logger.debug("{} is not supported for type erasure. Will by default return Object.", type.getClass());
        return Object.class;
    }

    private static Type[] getExactDirectSuperTypes(Type type) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            return TypeReflectionUtils.getExactDirectSuperTypesOfParameterizedTypeOrClass(type);
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds();
        }
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds();
        }
        if (type instanceof GenericArrayType) {
            return TypeReflectionUtils.getExactDirectSuperTypes(((GenericArrayType)type).getGenericComponentType());
        }
        if (type == null) {
            throw new IllegalArgumentException("Cannot handle given Type of null");
        }
        logger.debug("{} is not supported for retrieving the exact direct super types from. Will by default return the type contained in an Type[]", type.getClass());
        return new Type[]{type};
    }

    private static Type[] getExactDirectSuperTypesOfParameterizedTypeOrClass(Type type) {
        Type[] result;
        Class clazz;
        if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            clazz = (Class)type;
            if (clazz.isArray()) {
                Class<?> typeComponent = clazz.getComponentType();
                Type[] componentSupertypes = TypeReflectionUtils.getExactDirectSuperTypes(typeComponent);
                Type[] result2 = new Type[componentSupertypes.length + 3];
                for (int resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                    result2[resultIndex] = Array.newInstance((Class)componentSupertypes[resultIndex], 0).getClass();
                }
                return result2;
            }
        }
        Type[] superInterfaces = clazz.getGenericInterfaces();
        Type superClass = clazz.getGenericSuperclass();
        if (superClass == null && superInterfaces.length == 0 && clazz.isInterface()) {
            return new Type[]{Object.class};
        }
        if (superClass == null) {
            result = new Type[superInterfaces.length];
            resultIndex = 0;
        } else {
            result = new Type[superInterfaces.length + 1];
            resultIndex = 1;
            result[0] = TypeReflectionUtils.mapTypeParameters(superClass, type);
        }
        for (Type superInterface : superInterfaces) {
            result[resultIndex++] = TypeReflectionUtils.mapTypeParameters(superInterface, type);
        }
        return result;
    }

    private static Type mapTypeParameters(Type toMapType, Type typeAndParams) {
        if (TypeReflectionUtils.isMissingTypeParameters(typeAndParams)) {
            return TypeReflectionUtils.erase(toMapType);
        }
        VarMap varMap = new VarMap();
        Type handlingTypeAndParams = typeAndParams;
        while (handlingTypeAndParams instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)handlingTypeAndParams;
            Class rawType = (Class)pType.getRawType();
            varMap.addAll(rawType.getTypeParameters(), pType.getActualTypeArguments());
            handlingTypeAndParams = pType.getOwnerType();
        }
        return varMap.map(toMapType);
    }

    private static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        logger.debug("{} is not supported for checking if there are missing type parameters. Will by default return false.", type.getClass());
        return false;
    }

    private TypeReflectionUtils() {
    }

    private static class VarMap {
        private final Map<TypeVariable<?>, Type> map = new HashMap();

        VarMap() {
        }

        private void addAll(TypeVariable<?>[] variables, Type[] values) {
            assert (variables.length == values.length);
            IntStream.range(0, variables.length).forEach(i -> this.map.put(variables[i], values[i]));
        }

        private Type map(Type type) {
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                if (!this.map.containsKey(type)) {
                    throw new UnresolvedTypeVariableException((TypeVariable)type);
                }
                return this.map.get(type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type[] actualTypeArguments = this.map(pType.getActualTypeArguments());
                Type ownerType = pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType());
                return new ParameterizedTypeImpl((Class)pType.getRawType(), actualTypeArguments, ownerType);
            }
            logger.debug("{} is not supported for variable mapping. Will by default return the type as is.", type.getClass());
            return type;
        }

        private Type[] map(Type[] types) {
            return (Type[])Arrays.stream(types).map(this::map).toArray(Type[]::new);
        }

        private static class UnresolvedTypeVariableException
        extends RuntimeException {
            UnresolvedTypeVariableException(TypeVariable<?> tv) {
                super("An exact type is requested, but the type contains a type variable that cannot be resolved.\n   Variable: " + tv.getName() + " from " + String.valueOf(tv.getGenericDeclaration()) + "\n   Hint: This is usually caused by trying to get an exact type when a generic method who's type parameters are not given is involved.");
            }
        }

        private static class ParameterizedTypeImpl
        implements ParameterizedType {
            private final Class<?> rawType;
            private final Type[] actualTypeArguments;
            private final Type ownerType;

            ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
                this.rawType = rawType;
                this.actualTypeArguments = actualTypeArguments;
                this.ownerType = ownerType;
            }

            @Override
            public Type getRawType() {
                return this.rawType;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return this.actualTypeArguments;
            }

            @Override
            public Type getOwnerType() {
                return this.ownerType;
            }
        }
    }
}

