/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.detection;

import java.util.Arrays;
import org.axonframework.common.annotation.Internal;

@Internal
public class TestEnvironmentDetector {
    public static final String AXONIQ_USAGE_FORCE_TEST_ENVIRONMENT = "axoniq.usage.force-test-environment";

    public static boolean isTestEnvironment() {
        if (System.getProperty(AXONIQ_USAGE_FORCE_TEST_ENVIRONMENT, "false").equals("true")) {
            return false;
        }
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(TestEnvironmentDetector::isTestClass);
    }

    private static boolean isTestClass(StackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        return className.startsWith("org.junit") || className.startsWith("org.testng") || className.startsWith("org.spockframework") || className.startsWith("org.mockito") || className.startsWith("io.cucumber") || className.startsWith("org.cucumber") || className.startsWith("org.assertj") || className.startsWith("org.hamcrest") || className.startsWith("org.jboss.arquillian") || className.startsWith("org.arquillian") || className.startsWith("org.springframework.test") || className.startsWith("org.springframework.boot.test") || className.startsWith("io.kotest") || className.startsWith("io.kotlintest") || className.startsWith("org.scalatest") || className.startsWith("org.jbehave") || className.startsWith("org.easymock") || className.startsWith("org.powermock") || className.startsWith("org.spekframework") || className.startsWith("net.jqwik") || className.startsWith("org.quicktheories") || className.startsWith("fit.") || className.startsWith("fitnesse.") || className.startsWith("org.concordion") || className.startsWith("com.consol.citrus") || className.startsWith("org.pitest") || className.startsWith("org.testcontainers") || className.startsWith("org.robolectric") || className.startsWith("net.serenitybdd") || className.startsWith("geb.") || className.startsWith("cucumber.api") || className.startsWith("org.jmock") || className.startsWith("mockit") || className.startsWith("play.test") || className.startsWith("com.codeborne.selenide") || className.startsWith("org.openqa.selenium") || className.startsWith("junitparams") || className.startsWith("org.testfx") || className.startsWith("com.intellij") || className.startsWith("org.gradle.api.internal.tasks.testing");
    }
}

