/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.commons.lang3.tuple.Pair;
import org.axonframework.serialization.avro.AvroUtil;
import org.axonframework.serialization.avro.SchemaIncompatibilityChecker;

public class DefaultSchemaIncompatibilityChecker
implements SchemaIncompatibilityChecker {
    private final ConcurrentHashMap<Pair<Long, Long>, List<SchemaCompatibility.Incompatibility>> cache = new ConcurrentHashMap();

    @Override
    @Nonnull
    public List<SchemaCompatibility.Incompatibility> checkCompatibility(@Nonnull Schema readerSchema, @Nonnull Schema writerSchema) {
        return this.cache.computeIfAbsent((Pair<Long, Long>)Pair.of((Object)AvroUtil.fingerprint(readerSchema), (Object)AvroUtil.fingerprint(writerSchema)), key -> SchemaIncompatibilityChecker.super.checkCompatibility(readerSchema, writerSchema));
    }

    Map<Pair<Long, Long>, List<SchemaCompatibility.Incompatibility>> getIncompatibilitiesCache() {
        HashMap<Pair<Long, Long>, List<SchemaCompatibility.Incompatibility>> copy = new HashMap<Pair<Long, Long>, List<SchemaCompatibility.Incompatibility>>(this.cache.size());
        copy.putAll(this.cache);
        return copy;
    }

    void clear() {
        this.cache.clear();
    }
}

