/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.serialization.ChainedConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.ConversionException;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingContentTypeConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(ChainingContentTypeConverter.class);
    private final List<ContentTypeConverter<?, ?>> converters = new CopyOnWriteArrayList();

    public ChainingContentTypeConverter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ChainingContentTypeConverter(@Nonnull ClassLoader classLoader) {
        ServiceLoader<ContentTypeConverter> converterLoader = ServiceLoader.load(ContentTypeConverter.class, classLoader);
        for (ContentTypeConverter converter : converterLoader) {
            this.converters.add(converter);
        }
    }

    @Override
    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        Class sourceClass;
        block6: {
            block5: {
                if (sourceType.equals(targetType)) {
                    return true;
                }
                if (!(sourceType instanceof Class)) break block5;
                sourceClass = (Class)sourceType;
                if (targetType instanceof Class) break block6;
            }
            return false;
        }
        Class targetClass = (Class)targetType;
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, sourceClass, targetClass)) continue;
            return true;
        }
        return ChainedConverter.canConvert(sourceClass, targetClass, this.converters);
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        if (input == null) {
            return null;
        }
        Class<?> sourceType = input.getClass();
        if (sourceType.equals(targetType)) {
            return (T)input;
        }
        if (!(targetType instanceof Class)) {
            throw new ConversionException("The targetType [" + String.valueOf(targetType) + "] is not of type Class<?>, while the ChainingContentTypeConverter can only deal with Class<?>.");
        }
        Class targetClass = (Class)targetType;
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, input.getClass(), targetClass)) continue;
            ContentTypeConverter<?, ?> typedConverter = converter;
            return (T)typedConverter.convert(input);
        }
        ChainedConverter converter = ChainedConverter.calculateChain(input.getClass(), targetClass, this.converters);
        this.converters.addFirst(converter);
        return converter.convert(input);
    }

    private <S, T> boolean canConvert(ContentTypeConverter<?, ?> converter, Class<S> sourceContentType, Class<T> targetContentType) {
        try {
            if (converter.expectedSourceType().isAssignableFrom(sourceContentType) && targetContentType.isAssignableFrom(converter.targetType())) {
                return true;
            }
            converter.targetType();
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converter, (Object)e.getMessage());
            this.converters.remove(converter);
        }
        return false;
    }

    public void registerConverter(@Nonnull ContentTypeConverter<?, ?> converter) {
        this.converters.addFirst(converter);
    }

    public void registerConverter(@Nonnull Class<? extends ContentTypeConverter<?, ?>> converterType) {
        try {
            ContentTypeConverter<?, ?> converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            converter.targetType();
            converter.expectedSourceType();
            this.registerConverter(converter);
        }
        catch (Exception e) {
            logger.warn("An exception occurred while trying to initialize a [{}].", (Object)converterType.getName(), (Object)e);
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter of type [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converterType, (Object)e.getMessage());
        }
    }

    public void setAdditionalConverters(@Nonnull List<ContentTypeConverter<?, ?>> additionalConverters) {
        additionalConverters.forEach(this::registerConverter);
    }

    @Nonnull
    public List<ContentTypeConverter<?, ?>> getContentTypeConverters() {
        return Collections.unmodifiableList(this.converters);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("content-type-converters", this.converters);
    }
}

