/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface ProcessingLifecycle {
    public boolean isStarted();

    public boolean isError();

    public boolean isCommitted();

    public boolean isCompleted();

    public ProcessingLifecycle on(Phase var1, Function<ProcessingContext, CompletableFuture<?>> var2);

    default public ProcessingLifecycle runOn(Phase phase, Consumer<ProcessingContext> action) {
        return this.on(phase, c -> {
            action.accept((ProcessingContext)c);
            return FutureUtils.emptyCompletedFuture();
        });
    }

    default public ProcessingLifecycle onPreInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.PRE_INVOCATION, action);
    }

    default public ProcessingLifecycle runOnPreInvocation(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.PRE_INVOCATION, action);
    }

    default public ProcessingLifecycle onInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.INVOCATION, action);
    }

    default public ProcessingLifecycle runOnInvocation(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.INVOCATION, action);
    }

    default public ProcessingLifecycle onPostInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.POST_INVOCATION, action);
    }

    default public ProcessingLifecycle runOnPostInvocation(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.POST_INVOCATION, action);
    }

    default public ProcessingLifecycle onPrepareCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.PREPARE_COMMIT, action);
    }

    default public ProcessingLifecycle runOnPrepareCommit(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.PREPARE_COMMIT, action);
    }

    default public ProcessingLifecycle onCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.COMMIT, action);
    }

    default public ProcessingLifecycle runOnCommit(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.COMMIT, action);
    }

    default public ProcessingLifecycle onAfterCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.on(DefaultPhases.AFTER_COMMIT, action);
    }

    default public ProcessingLifecycle runOnAfterCommit(Consumer<ProcessingContext> action) {
        return this.runOn(DefaultPhases.AFTER_COMMIT, action);
    }

    public ProcessingLifecycle onError(ErrorHandler var1);

    public ProcessingLifecycle whenComplete(Consumer<ProcessingContext> var1);

    default public ProcessingLifecycle doFinally(Consumer<ProcessingContext> action) {
        this.onError((c, p, e) -> action.accept(c));
        this.whenComplete(action);
        return this;
    }

    public static interface Phase {
        public int order();

        default public boolean isBefore(Phase other) {
            return this.order() < other.order();
        }

        default public boolean isAfter(Phase other) {
            return this.order() > other.order();
        }
    }

    public static enum DefaultPhases implements Phase
    {
        PRE_INVOCATION(-10000),
        INVOCATION(0),
        POST_INVOCATION(10000),
        PREPARE_COMMIT(20000),
        COMMIT(30000),
        AFTER_COMMIT(40000);

        private final int order;

        private DefaultPhases(int order) {
            this.order = order;
        }

        @Override
        public int order() {
            return this.order;
        }
    }

    @FunctionalInterface
    public static interface ErrorHandler {
        public void handle(ProcessingContext var1, Phase var2, Throwable var3);
    }
}

