/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.eventstreaming.AnyEvent;
import org.axonframework.eventstreaming.EventCriterion;
import org.axonframework.eventstreaming.EventTypeRestrictableEventCriteria;
import org.axonframework.eventstreaming.OrEventCriteria;
import org.axonframework.eventstreaming.OrEventCriteriaBuilder;
import org.axonframework.eventstreaming.Tag;
import org.axonframework.eventstreaming.TagAndTypeFilteredEventCriteria;
import org.axonframework.eventstreaming.TagFilteredEventCriteria;
import org.axonframework.messaging.QualifiedName;

public sealed interface EventCriteria
permits OrEventCriteria, TagAndTypeFilteredEventCriteria, TagFilteredEventCriteria, AnyEvent, EventCriterion, EventTypeRestrictableEventCriteria {
    public static EventTypeRestrictableEventCriteria havingAnyTag() {
        return AnyEvent.INSTANCE;
    }

    public static EventTypeRestrictableEventCriteria havingTags(@Nonnull Set<Tag> tags) {
        if (tags.isEmpty()) {
            return AnyEvent.INSTANCE;
        }
        return new TagFilteredEventCriteria(tags);
    }

    public static EventTypeRestrictableEventCriteria havingTags(Tag ... tags) {
        return EventCriteria.havingTags(Set.of(tags));
    }

    public static EventTypeRestrictableEventCriteria havingTags(String ... tags) {
        if ((tags.length & 1) == 1) {
            throw new IllegalArgumentException("Tags must be in pairs of key and value");
        }
        HashSet<Tag> tagSet = new HashSet<Tag>();
        for (int i = 0; i < tags.length; i += 2) {
            tagSet.add(new Tag(tags[i], tags[i + 1]));
        }
        return EventCriteria.havingTags(tagSet);
    }

    public EventCriteria or(EventCriteria var1);

    public static EventCriteria either(EventCriteria ... eventCriteria) {
        return new OrEventCriteria(Arrays.stream(eventCriteria).collect(Collectors.toSet()));
    }

    default public OrEventCriteriaBuilder or() {
        return new OrEventCriteriaBuilder(this);
    }

    public boolean matches(@Nonnull QualifiedName var1, @Nonnull Set<Tag> var2);

    public Set<EventCriterion> flatten();

    public boolean hasCriteria();
}

