/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.SchedulingException;
import org.axonframework.eventhandling.scheduling.quartz.EventJobDataBinder;
import org.axonframework.eventhandling.scheduling.quartz.FireEventJob;
import org.axonframework.eventhandling.scheduling.quartz.QuartzScheduleToken;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzEventScheduler
implements EventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(QuartzEventScheduler.class);
    private static final String JOB_NAME_PREFIX = "event-";
    private static final String DEFAULT_GROUP_NAME = "AxonFramework-Events";
    private final Scheduler scheduler;
    private final EventBus eventBus;
    private final EventJobDataBinder jobDataBinder;
    private final TransactionManager transactionManager;
    private final MessageTypeResolver messageTypeResolver;
    private String groupIdentifier = "AxonFramework-Events";
    private volatile boolean initialized;

    protected QuartzEventScheduler(Builder builder) {
        builder.validate();
        this.scheduler = builder.scheduler;
        this.eventBus = builder.eventBus;
        this.jobDataBinder = builder.jobDataBinderSupplier.get();
        this.transactionManager = builder.transactionManager;
        this.messageTypeResolver = builder.messageTypeResolver;
        try {
            this.initialize();
        }
        catch (SchedulerException e) {
            throw new AxonConfigurationException("Unable to initialize QuartzEventScheduler", e);
        }
    }

    private void initialize() throws SchedulerException {
        this.scheduler.getContext().put(FireEventJob.EVENT_BUS_KEY, (Object)this.eventBus);
        this.scheduler.getContext().put(FireEventJob.TRANSACTION_MANAGER_KEY, (Object)this.transactionManager);
        this.scheduler.getContext().put(FireEventJob.EVENT_JOB_DATA_BINDER_KEY, (Object)this.jobDataBinder);
        this.scheduler.getContext().put(FireEventJob.MESSAGE_TYPE_RESOLVER_KEY, (Object)this.messageTypeResolver);
        this.initialized = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        Assert.state(this.initialized, () -> "Scheduler is not yet initialized");
        EventMessage eventMessage = this.asEventMessage(event);
        String jobIdentifier = JOB_NAME_PREFIX + eventMessage.identifier();
        QuartzScheduleToken tr = new QuartzScheduleToken(jobIdentifier, this.groupIdentifier);
        try {
            JobDetail jobDetail = this.buildJobDetail(eventMessage, new JobKey(jobIdentifier, this.groupIdentifier));
            this.scheduler.scheduleJob(jobDetail, this.buildTrigger(triggerDateTime, jobDetail.getKey()));
        }
        catch (SchedulerException e) {
            throw new SchedulingException("An error occurred while scheduling an event.", e);
        }
        return tr;
    }

    private EventMessage asEventMessage(@Nonnull Object event) {
        if (event instanceof EventMessage) {
            EventMessage e = (EventMessage)event;
            return e;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage(message, () -> GenericEventMessage.clock.instant());
        }
        return new GenericEventMessage(this.messageTypeResolver.resolveOrThrow(event), event, MetaData.emptyInstance());
    }

    protected JobDetail buildJobDetail(EventMessage event, JobKey jobKey) {
        JobDataMap jobData = this.jobDataBinder.toJobData(event);
        return JobBuilder.newJob(FireEventJob.class).withDescription(event.type().name()).withIdentity(jobKey).usingJobData(jobData).build();
    }

    protected Trigger buildTrigger(Instant triggerDateTime, JobKey jobKey) {
        return TriggerBuilder.newTrigger().forJob(jobKey).startAt(Date.from(triggerDateTime)).build();
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        return this.schedule(GenericEventMessage.clock.instant().plus(triggerDuration), event);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!(scheduleToken instanceof QuartzScheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        Assert.state(this.initialized, () -> "Scheduler is not yet initialized");
        QuartzScheduleToken reference = (QuartzScheduleToken)scheduleToken;
        try {
            if (!this.scheduler.deleteJob(JobKey.jobKey((String)reference.getJobIdentifier(), (String)reference.getGroupIdentifier()))) {
                logger.warn("The job belonging to this token could not be deleted.");
            }
        }
        catch (SchedulerException e) {
            throw new SchedulingException("An error occurred while cancelling a timer for a saga", e);
        }
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    @Override
    public void shutdown() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new SchedulingException("An error occurred while trying to shutdown the event scheduler", e);
        }
    }

    public static class Builder {
        private Scheduler scheduler;
        private EventBus eventBus;
        private Supplier<EventJobDataBinder> jobDataBinderSupplier;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private Supplier<Serializer> serializer;
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public Builder scheduler(Scheduler scheduler) {
            BuilderUtils.assertNonNull(scheduler, "Scheduler may not be null");
            this.scheduler = scheduler;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            BuilderUtils.assertNonNull(eventBus, "EventBus may not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder jobDataBinder(EventJobDataBinder jobDataBinder) {
            BuilderUtils.assertNonNull(jobDataBinder, "EventJobDataBinder may not be null");
            this.jobDataBinderSupplier = () -> jobDataBinder;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = () -> serializer;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public QuartzEventScheduler build() {
            return new QuartzEventScheduler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scheduler, "The Scheduler is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.eventBus, "The EventBus is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided");
            if (this.jobDataBinderSupplier == null) {
                this.jobDataBinderSupplier = () -> new DirectEventJobDataBinder(this.serializer.get());
            }
        }
    }

    public static class DirectEventJobDataBinder
    implements EventJobDataBinder {
        public static final String MESSAGE_ID = "axon-message-id";
        public static final String SERIALIZED_MESSAGE_PAYLOAD = "axon-serialized-message-payload";
        public static final String MESSAGE_TYPE = "axon-message-type";
        public static final String MESSAGE_REVISION = "axon-message-revision";
        public static final String MESSAGE_TIMESTAMP = "axon-message-timestamp";
        public static final String MESSAGE_METADATA = "axon-metadata";
        public static final String TYPE = "type";
        private final Serializer serializer;

        public DirectEventJobDataBinder(Serializer serializer) {
            this.serializer = serializer;
        }

        @Override
        public JobDataMap toJobData(Object event) {
            JobDataMap jobData = new JobDataMap();
            EventMessage eventMessage = (EventMessage)event;
            jobData.put(MESSAGE_ID, eventMessage.identifier());
            jobData.put(TYPE, eventMessage.type().toString());
            jobData.put(MESSAGE_TIMESTAMP, eventMessage.timestamp().toString());
            SerializedObject<byte[]> serializedPayload = this.serializer.serialize(eventMessage.payload(), byte[].class);
            jobData.put(SERIALIZED_MESSAGE_PAYLOAD, (Object)serializedPayload.getData());
            jobData.put(MESSAGE_TYPE, serializedPayload.getType().getName());
            jobData.put(MESSAGE_REVISION, serializedPayload.getType().getRevision());
            SerializedObject<byte[]> serializedMetaData = this.serializer.serialize(eventMessage.metaData(), byte[].class);
            jobData.put(MESSAGE_METADATA, (Object)serializedMetaData.getData());
            return jobData;
        }

        @Override
        public Object fromJobData(JobDataMap jobDataMap) {
            return new GenericEventMessage((String)jobDataMap.get((Object)MESSAGE_ID), MessageType.fromString((String)jobDataMap.get((Object)TYPE)), this.deserializePayload(jobDataMap), this.deserializeMetaData(jobDataMap), this.retrieveDeadlineTimestamp(jobDataMap));
        }

        private Object deserializePayload(JobDataMap jobDataMap) {
            SimpleSerializedObject<byte[]> serializedPayload = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)SERIALIZED_MESSAGE_PAYLOAD), byte[].class, (String)jobDataMap.get((Object)MESSAGE_TYPE), (String)jobDataMap.get((Object)MESSAGE_REVISION));
            return this.serializer.deserialize(serializedPayload);
        }

        private Map<String, String> deserializeMetaData(JobDataMap jobDataMap) {
            SimpleSerializedObject<byte[]> serializedDeadlineMetaData = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)MESSAGE_METADATA), byte[].class, MetaData.class.getName(), null);
            return (Map)this.serializer.deserialize(serializedDeadlineMetaData);
        }

        private Instant retrieveDeadlineTimestamp(JobDataMap jobDataMap) {
            Object timestamp = jobDataMap.get((Object)MESSAGE_TIMESTAMP);
            if (timestamp instanceof String) {
                return Instant.parse(timestamp.toString());
            }
            return Instant.ofEpochMilli((Long)timestamp);
        }
    }
}

