/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.gateway.EventAppender;
import org.axonframework.eventhandling.gateway.EventPublishingUtils;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class ProcessingContextEventAppender
implements EventAppender {
    private final ProcessingContext processingContext;
    private final EventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;

    ProcessingContextEventAppender(ProcessingContext processingContext, EventSink eventSink, MessageTypeResolver messageTypeResolver) {
        this.processingContext = Objects.requireNonNull(processingContext, "ProcessingContext may not be null");
        this.eventSink = Objects.requireNonNull(eventSink, "EventSink may not be null");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "MessageTypeResolver may not be null");
    }

    @Override
    public void append(@Nonnull List<?> events) {
        Objects.requireNonNull(events, "Events may not be null");
        List<EventMessage> eventMessages = events.stream().map(e -> EventPublishingUtils.asEventMessage(e, this.messageTypeResolver)).collect(Collectors.toList());
        this.eventSink.publish(this.processingContext, eventMessages);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("processingContext", this.processingContext);
        descriptor.describeProperty("eventSink", this.eventSink);
        descriptor.describeProperty("messageTypeResolver", this.messageTypeResolver);
    }
}

