/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SequenceIdentifierCache {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int segmentId;
    private final boolean startedEmpty;
    private final int maxSize;
    private final LinkedList<Object> nonEnqueuedIdentifiers = new LinkedList();
    private final Set<Object> enqueuedIdentifiers = new HashSet<Object>();

    SequenceIdentifierCache(int segmentId, int maxSize, SequencedDeadLetterQueue<EventMessage> queue) {
        this.segmentId = segmentId;
        this.maxSize = maxSize;
        this.startedEmpty = queue.amountOfSequences() == 0L;
    }

    boolean mightBePresent(Object sequenceIdentifier) {
        if (this.enqueuedIdentifiers.contains(sequenceIdentifier)) {
            return true;
        }
        if (this.startedEmpty) {
            return false;
        }
        return !this.nonEnqueuedIdentifiers.contains(sequenceIdentifier);
    }

    SequenceIdentifierCache markEnqueued(Object sequenceIdentifier) {
        if (logger.isTraceEnabled()) {
            logger.trace("Marked sequenceIdentifier [{}] as present to the cache for segment [{}].", sequenceIdentifier, (Object)this.segmentId);
        }
        this.enqueuedIdentifiers.add(sequenceIdentifier);
        this.nonEnqueuedIdentifiers.remove(sequenceIdentifier);
        return this;
    }

    SequenceIdentifierCache markNotEnqueued(Object sequenceIdentifier) {
        if (logger.isTraceEnabled()) {
            logger.trace("Marked sequenceIdentifier [{}] as not present to the cache for segment [{}].", sequenceIdentifier, (Object)this.segmentId);
        }
        if (!this.startedEmpty) {
            this.nonEnqueuedIdentifiers.add(sequenceIdentifier);
            if (this.nonEnqueuedIdentifiers.size() > this.maxSize) {
                this.nonEnqueuedIdentifiers.removeFirst();
            }
        }
        this.enqueuedIdentifiers.remove(sequenceIdentifier);
        return this;
    }
}

