/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.axonframework.common.annotation.Internal;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.configuration.EventHandlingComponentsConfigurer;

@Internal
public class DefaultEventHandlingComponentsConfigurer
implements EventHandlingComponentsConfigurer.RequiredComponentPhase,
EventHandlingComponentsConfigurer.AdditionalComponentPhase,
EventHandlingComponentsConfigurer.CompletePhase {
    private List<ComponentBuilder<EventHandlingComponent>> componentBuilders = new ArrayList<ComponentBuilder<EventHandlingComponent>>();

    @Override
    @Nonnull
    public EventHandlingComponentsConfigurer.AdditionalComponentPhase declarative(@Nonnull ComponentBuilder<EventHandlingComponent> handlingComponentBuilder) {
        Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
        this.componentBuilders.add(handlingComponentBuilder);
        return this;
    }

    @Override
    @Nonnull
    public EventHandlingComponentsConfigurer.CompletePhase decorated(@Nonnull BiFunction<Configuration, EventHandlingComponent, EventHandlingComponent> decorator) {
        Objects.requireNonNull(decorator, "decorator may not be null");
        ArrayList<ComponentBuilder<EventHandlingComponent>> decoratedBuilders = new ArrayList<ComponentBuilder<EventHandlingComponent>>();
        for (ComponentBuilder<EventHandlingComponent> builder : this.componentBuilders) {
            decoratedBuilders.add(cfg -> {
                EventHandlingComponent component = (EventHandlingComponent)builder.build(cfg);
                return (EventHandlingComponent)decorator.apply(cfg, component);
            });
        }
        this.componentBuilders = decoratedBuilders;
        return this;
    }

    @Override
    @Nonnull
    public List<ComponentBuilder<EventHandlingComponent>> toList() {
        return List.copyOf(this.componentBuilders);
    }
}

