/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.SequenceOverridingEventHandlingComponent;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.configuration.EventHandlingComponentBuilder;
import org.axonframework.messaging.QualifiedName;

public class DefaultEventHandlingComponentBuilder
implements EventHandlingComponentBuilder.SequencingPolicyPhase,
EventHandlingComponentBuilder.RequiredEventHandlerPhase,
EventHandlingComponentBuilder.AdditionalEventHandlerPhase,
EventHandlingComponentBuilder.CompletePhase {
    private EventHandlingComponent component;

    public DefaultEventHandlingComponentBuilder(@Nonnull EventHandlingComponent component) {
        this.component = Objects.requireNonNull(component, "EventHandlingComponent may not be null");
    }

    @Override
    public EventHandlingComponentBuilder.RequiredEventHandlerPhase sequencingPolicy(@Nonnull SequencingPolicy sequencingPolicy) {
        this.component = new SequenceOverridingEventHandlingComponent(Objects.requireNonNull(sequencingPolicy, "SequencingPolicy may not be null"), this.component);
        return this;
    }

    @Override
    @Nonnull
    public EventHandlingComponentBuilder.AdditionalEventHandlerPhase handles(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        this.component.subscribe(name, eventHandler);
        return this;
    }

    @Override
    @Nonnull
    public EventHandlingComponentBuilder.AdditionalEventHandlerPhase handles(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler eventHandler) {
        this.component.subscribe(names, eventHandler);
        return this;
    }

    @Override
    @Nonnull
    public EventHandlingComponentBuilder.CompletePhase decorated(@Nonnull UnaryOperator<EventHandlingComponent> decorator) {
        this.component = (EventHandlingComponent)Objects.requireNonNull(decorator, "Decorator may not be null").apply(this.component);
        return this;
    }

    @Override
    @Nonnull
    public EventHandlingComponent build() {
        return this.component;
    }
}

