/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class PropertySequencingPolicy<T, K>
implements SequencingPolicy {
    private final Class<T> payloadClass;
    private final Function<T, K> propertyExtractor;
    private final SequencingPolicy fallbackSequencingPolicy;

    protected PropertySequencingPolicy(Builder builder) {
        builder.validate();
        this.payloadClass = builder.payloadClass;
        this.propertyExtractor = builder.propertyExtractor;
        this.fallbackSequencingPolicy = builder.fallbackSequencingPolicy;
    }

    @Override
    public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context) {
        if (this.payloadClass.isAssignableFrom(eventMessage.payloadType())) {
            Object castedPayload = eventMessage.payload();
            return Optional.ofNullable(this.propertyExtractor.apply(castedPayload));
        }
        return this.fallbackSequencingPolicy.getSequenceIdentifierFor(eventMessage, context);
    }

    public static <T, K> Builder<T, K> builder(Class<T> payloadClass, Class<K> propertyClass) {
        return new Builder(payloadClass);
    }

    public static final class Builder<T, K> {
        private final Class<T> payloadClass;
        private Function<T, K> propertyExtractor;
        private SequencingPolicy fallbackSequencingPolicy = ExceptionRaisingSequencingPolicy.instance();

        private Builder(Class<T> payloadClass) {
            BuilderUtils.assertNonNull(payloadClass, "Payload class may not be null");
            this.payloadClass = payloadClass;
        }

        public Builder<T, K> propertyExtractor(Function<T, K> propertyExtractor) {
            BuilderUtils.assertNonNull(propertyExtractor, "Property extractor may not be null");
            this.propertyExtractor = propertyExtractor;
            return this;
        }

        public Builder<T, K> propertyName(String propertyName) {
            BuilderUtils.assertNonNull(propertyName, "Property may not be null");
            Property<T> property = PropertyAccessStrategy.getProperty(this.payloadClass, propertyName);
            BuilderUtils.assertNonNull(property, "Property cannot be found");
            this.propertyExtractor = property::getValue;
            return this;
        }

        public Builder<T, K> fallbackSequencingPolicy(SequencingPolicy fallbackSequencingPolicy) {
            BuilderUtils.assertNonNull(fallbackSequencingPolicy, "Fallback sequencing policy may not be null");
            this.fallbackSequencingPolicy = fallbackSequencingPolicy;
            return this;
        }

        public PropertySequencingPolicy<T, K> build() {
            return new PropertySequencingPolicy(this);
        }

        private void validate() {
            BuilderUtils.assertNonNull(this.payloadClass, "The payload class is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.propertyExtractor, "The property extractor is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.fallbackSequencingPolicy, "The fallback sequencing policy is a hard requirement and should be provided");
        }

        private static final class ExceptionRaisingSequencingPolicy
        implements SequencingPolicy {
            private static final ExceptionRaisingSequencingPolicy INSTANCE = new ExceptionRaisingSequencingPolicy();

            private ExceptionRaisingSequencingPolicy() {
            }

            public static ExceptionRaisingSequencingPolicy instance() {
                return INSTANCE;
            }

            @Override
            public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context) {
                throw new IllegalArgumentException("The event message payload is not of a supported type. Either make sure that the processor only consumes supported events or add a fallback sequencing policy.");
            }
        }
    }
}

