/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MetaDataSequencingPolicy
implements SequencingPolicy {
    private final String metaDataKey;

    protected MetaDataSequencingPolicy(Builder builder) {
        builder.validate();
        this.metaDataKey = builder.metaDataKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return Optional.ofNullable(event.metaData().getOrDefault(this.metaDataKey, event.identifier()));
    }

    public static class Builder {
        private String metaDataKey;

        private Builder() {
        }

        public Builder metaDataKey(String metaDataKey) {
            this.metaDataKey = metaDataKey;
            return this;
        }

        public MetaDataSequencingPolicy build() {
            return new MetaDataSequencingPolicy(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.metaDataKey, "MetaDataKey value may not be null");
        }
    }
}

