/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlerRegistry;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.SimpleEventHandlingComponent;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public class AnnotatedEventHandlingComponent<T>
implements EventHandlingComponent {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final EventHandlingComponent delegate;

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory) {
        this(annotatedEventHandler, parameterResolverFactory, new SimpleEventHandlingComponent(), ClasspathHandlerDefinition.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull EventHandlingComponent delegate) {
        this(annotatedEventHandler, parameterResolverFactory, delegate, ClasspathHandlerDefinition.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull EventHandlingComponent delegate, @Nonnull HandlerDefinition handlerDefinition) {
        this(annotatedEventHandler, delegate, AnnotatedHandlerInspector.inspectType(annotatedEventHandler.getClass(), parameterResolverFactory, handlerDefinition));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull EventHandlingComponent delegate, @Nonnull AnnotatedHandlerInspector<T> model) {
        this.target = Objects.requireNonNull(annotatedEventHandler, "The Annotated Event Handler may not be null");
        this.model = Objects.requireNonNull(model, "The Annotated Handler Inspector may not be null");
        this.delegate = delegate;
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(h -> h.canHandleMessageType(EventMessage.class)).forEach(this::registerHandler));
    }

    private void registerHandler(MessageHandlingMember<? super T> handler) {
        QualifiedName qualifiedName = new QualifiedName(handler.payloadType());
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        this.delegate.subscribe(qualifiedName, (EventMessage event, ProcessingContext ctx) -> interceptorChain.handle(event.withConvertedPayload((Class)handler.payloadType(), (Converter)ctx.component(EventConverter.class)), ctx, this.target, handler).ignoreEntries().cast());
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        return this.delegate.subscribe(name, eventHandler);
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.delegate.handle(event, context);
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.delegate.supportedEvents());
    }

    @Override
    @Nonnull
    public Object sequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.delegate.sequenceIdentifierFor(event, context);
    }
}

