/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.DirectEventProcessingStrategy;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessingStrategy;
import org.axonframework.eventhandling.EventProcessorSpanFactory;
import org.axonframework.eventhandling.configuration.EventProcessorConfiguration;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.monitoring.MessageMonitor;

public class SubscribingEventProcessorConfiguration
extends EventProcessorConfiguration {
    private SubscribableMessageSource<? extends EventMessage> messageSource;
    private EventProcessingStrategy processingStrategy = DirectEventProcessingStrategy.INSTANCE;

    public SubscribingEventProcessorConfiguration() {
    }

    public SubscribingEventProcessorConfiguration(@Nonnull EventProcessorConfiguration base) {
        super(base);
    }

    @Override
    public SubscribingEventProcessorConfiguration errorHandler(@Nonnull ErrorHandler errorHandler) {
        super.errorHandler(errorHandler);
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration messageMonitor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        super.messageMonitor(messageMonitor);
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration spanFactory(@Nonnull EventProcessorSpanFactory spanFactory) {
        super.spanFactory(spanFactory);
        return this;
    }

    public SubscribingEventProcessorConfiguration messageSource(@Nonnull SubscribableMessageSource<? extends EventMessage> messageSource) {
        BuilderUtils.assertNonNull(messageSource, "SubscribableMessageSource may not be null");
        this.messageSource = messageSource;
        return this;
    }

    public SubscribingEventProcessorConfiguration processingStrategy(@Nonnull EventProcessingStrategy processingStrategy) {
        BuilderUtils.assertNonNull(processingStrategy, "EventProcessingStrategy may not be null");
        this.processingStrategy = processingStrategy;
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration unitOfWorkFactory(@Nonnull UnitOfWorkFactory unitOfWorkFactory) {
        super.unitOfWorkFactory(unitOfWorkFactory);
        return this;
    }

    @Override
    public SubscribingEventProcessorConfiguration interceptors(@Nonnull List<MessageHandlerInterceptor<EventMessage>> interceptors) {
        super.interceptors(interceptors);
        return this;
    }

    @Override
    protected void validate() throws AxonConfigurationException {
        super.validate();
        BuilderUtils.assertNonNull(this.messageSource, "The SubscribableMessageSource is a hard requirement and should be provided");
    }

    public SubscribableMessageSource<? extends EventMessage> messageSource() {
        return this.messageSource;
    }

    public EventProcessingStrategy processingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        descriptor.describeProperty("messageSource", this.messageSource);
        descriptor.describeProperty("processingStrategy", this.processingStrategy);
    }
}

