/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultEventBusSpanFactory
implements EventBusSpanFactory {
    private final SpanFactory spanFactory;

    protected DefaultEventBusSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
    }

    @Override
    public Span createPublishEventSpan(EventMessage eventMessage) {
        return this.spanFactory.createDispatchSpan(() -> "EventBus.publishEvent", eventMessage, new Message[0]);
    }

    @Override
    public Span createCommitEventsSpan() {
        return this.spanFactory.createInternalSpan(() -> "EventBus.commitEvents");
    }

    @Override
    public EventMessage propagateContext(EventMessage eventMessage) {
        return this.spanFactory.propagateContext(eventMessage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.builderSpanFactory, "spanFactory may not be null");
        }

        public DefaultEventBusSpanFactory build() {
            return new DefaultEventBusSpanFactory(this);
        }
    }
}

