/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class DbSchedulerHumanReadableDeadlineDetails
implements Serializable {
    private String deadlineName;
    private String type;
    private String scopeDescriptor;
    private String scopeDescriptorClass;
    private String payload;
    private String payloadClass;
    private String payloadRevision;
    private String metaData;

    DbSchedulerHumanReadableDeadlineDetails() {
    }

    DbSchedulerHumanReadableDeadlineDetails(@Nonnull String deadlineName, @Nonnull String type, @Nonnull String scopeDescriptor, @Nonnull String scopeDescriptorClass, @Nullable String payload, @Nullable String payloadClass, @Nullable String payloadRevision, @Nullable String metaData) {
        this.deadlineName = deadlineName;
        this.type = type;
        this.scopeDescriptor = scopeDescriptor;
        this.scopeDescriptorClass = scopeDescriptorClass;
        this.payload = payload;
        this.payloadClass = payloadClass;
        this.payloadRevision = payloadRevision;
        this.metaData = metaData;
    }

    static DbSchedulerHumanReadableDeadlineDetails serialized(@Nonnull String deadlineName, @Nonnull ScopeDescriptor descriptor, @Nonnull DeadlineMessage message, @Nonnull Serializer serializer) {
        SerializedObject<String> serializedDescriptor = serializer.serialize(descriptor, String.class);
        SerializedObject<String> serializedPayload = serializer.serialize(message.payload(), String.class);
        SerializedObject<String> serializedMetaData = serializer.serialize(message.metaData(), String.class);
        return new DbSchedulerHumanReadableDeadlineDetails(deadlineName, message.type().toString(), serializedDescriptor.getData(), serializedDescriptor.getType().getName(), serializedPayload.getData(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedMetaData.getData());
    }

    public String getDeadlineName() {
        return this.deadlineName;
    }

    public String getType() {
        return this.type;
    }

    public String getScopeDescriptor() {
        return this.scopeDescriptor;
    }

    public String getScopeDescriptorClass() {
        return this.scopeDescriptorClass;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getPayloadClass() {
        return this.payloadClass;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public GenericDeadlineMessage asDeadLineMessage(Serializer serializer) {
        return new GenericDeadlineMessage(this.deadlineName, MessageType.fromString(this.type), this.getDeserializedPayload(serializer), this.getDeserializedMetaData(serializer));
    }

    private Object getDeserializedPayload(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlinePayload = new SimpleSerializedObject<String>(this.payload, String.class, this.payloadClass, this.payloadRevision);
        return serializer.deserialize(serializedDeadlinePayload);
    }

    private MetaData getDeserializedMetaData(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlineMetaData = new SimpleSerializedObject<String>(this.metaData, String.class, MetaData.class.getName(), null);
        return (MetaData)serializer.deserialize(serializedDeadlineMetaData);
    }

    public ScopeDescriptor getDeserializedScopeDescriptor(Serializer serializer) {
        SimpleSerializedObject<String> serializedDeadlineScope = new SimpleSerializedObject<String>(this.scopeDescriptor, String.class, this.scopeDescriptorClass, null);
        return (ScopeDescriptor)serializer.deserialize(serializedDeadlineScope);
    }

    public String toString() {
        return String.format("DbScheduler deadline details, deadlineName: [%s], type: [%s], scopeDescriptor: [%s], scopeDescriptorClass: [%s], payload: [%s], payloadClass: [%s], payloadRevision: [%s], metadata: [%s]", this.deadlineName, this.type, this.scopeDescriptor, this.scopeDescriptorClass, this.payload, this.payloadClass, this.payloadRevision, this.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.deadlineName, this.type, this.scopeDescriptor, this.scopeDescriptorClass, this.payload, this.payloadClass, this.payloadRevision, this.metaData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DbSchedulerHumanReadableDeadlineDetails other = (DbSchedulerHumanReadableDeadlineDetails)obj;
        return Objects.equals(this.deadlineName, other.deadlineName) && Objects.equals(this.type, other.type) && Objects.equals(this.scopeDescriptor, other.scopeDescriptor) && Objects.equals(this.scopeDescriptorClass, other.scopeDescriptorClass) && Objects.equals(this.payload, other.payload) && Objects.equals(this.payloadClass, other.payloadClass) && Objects.equals(this.payloadRevision, other.payloadRevision) && Objects.equals(this.metaData, other.metaData);
    }
}

